/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.OperationService;

public class MasterConfirmationOperation
extends AbstractClusterOperation {
    @Override
    public void run() {
        Address endpoint = this.getCallerAddress();
        if (endpoint == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        ILogger logger = this.getNodeEngine().getLogger(MasterConfirmationOperation.class.getName());
        MemberImpl member = clusterService.getMember(endpoint);
        if (member == null) {
            logger.warning("MasterConfirmation has been received from " + endpoint + ", but it is not a member of this cluster!");
            OperationService operationService = this.getNodeEngine().getOperationService();
            operationService.send(new MemberRemoveOperation(clusterService.getThisAddress()), endpoint);
        } else if (clusterService.isMaster()) {
            clusterService.acceptMasterConfirmation(member);
        } else {
            logger.warning(endpoint + " has sent MasterConfirmation, but this node is not master!");
        }
    }
}

