/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public class SnacFamilyInfo
implements Writable {
    private final int family;
    private final int version;
    private final int toolID;
    private final int toolVersion;

    protected static SnacFamilyInfo readSnacFamilyInfo(ByteBlock byteBlock) {
        DefensiveTools.checkNull(byteBlock, "block");
        int n = BinaryTools.getUShort(byteBlock, 0);
        int n2 = BinaryTools.getUShort(byteBlock, 2);
        int n3 = BinaryTools.getUShort(byteBlock, 4);
        int n4 = BinaryTools.getUShort(byteBlock, 6);
        return new SnacFamilyInfo(n, n2, n3, n4);
    }

    public SnacFamilyInfo(int n, int n2) {
        this(n, n2, -1, -1);
    }

    public SnacFamilyInfo(int n, int n2, int n3, int n4) {
        DefensiveTools.checkRange(n, "family", 0);
        DefensiveTools.checkRange(n2, "version", 0);
        DefensiveTools.checkRange(n3, "toolID", -1);
        DefensiveTools.checkRange(n4, "toolVersion", -1);
        this.family = n;
        this.version = n2;
        this.toolID = n3;
        this.toolVersion = n4;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getToolID() {
        return this.toolID;
    }

    public final int getToolVersion() {
        return this.toolVersion;
    }

    public long getWritableLength() {
        return 8L;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.family);
        BinaryTools.writeUShort(outputStream, this.version);
        if (this.toolID != -1 && this.toolVersion != -1) {
            BinaryTools.writeUShort(outputStream, this.toolID);
            BinaryTools.writeUShort(outputStream, this.toolVersion);
        }
    }

    public String toString() {
        return "SnacFamilyInfo: family=0x" + Integer.toHexString(this.family) + ", version=0x" + Integer.toHexString(this.version) + ", toolID=0x" + Integer.toHexString(this.toolID) + ", toolVersion=0x" + Integer.toHexString(this.toolVersion);
    }
}

