/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import javax.sip.Dialog;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.TransactionState;
import javax.sip.message.Request;
import javax.sip.message.Response;

public abstract class SIPTransaction
extends MessageChannel
implements Transaction {
    protected static final int BASE_TIMER_INTERVAL = 500;
    protected static final int T1 = 1;
    protected static final int T4 = 10;
    protected static final int T2 = 8;
    protected static final int TIMER_A = 1;
    protected static final int TIMER_B = 64;
    protected static final int TIMER_J = 64;
    protected static final int TIMER_F = 64;
    protected static final int TIMER_H = 64;
    protected static final int TIMER_I = 10;
    protected static final int TIMER_K = 10;
    protected static final int TIMER_D = 64;
    protected static final int TIMER_C = 360;
    protected Object applicationData;
    protected SIPResponse lastResponse;
    protected SIPDialog dialog;
    protected boolean isMapped;
    protected boolean isAckSeen;
    protected boolean eventPending;
    protected String transactionId;
    public static final TransactionState INITIAL_STATE = null;
    public static final TransactionState TRYING_STATE = TransactionState.TRYING;
    public static final TransactionState CALLING_STATE = TransactionState.CALLING;
    public static final TransactionState PROCEEDING_STATE = TransactionState.PROCEEDING;
    public static final TransactionState COMPLETED_STATE = TransactionState.COMPLETED;
    public static final TransactionState CONFIRMED_STATE = TransactionState.CONFIRMED;
    public static final TransactionState TERMINATED_STATE = TransactionState.TERMINATED;
    protected static final int MAXIMUM_RETRANSMISSION_TICK_COUNT = 8;
    protected SIPTransactionStack sipStack;
    protected SIPRequest originalRequest;
    protected MessageChannel encapsulatedChannel;
    protected int peerPort;
    protected InetAddress peerInetAddress;
    protected String peerAddress;
    protected String peerProtocol;
    protected int peerPacketSourcePort;
    protected InetAddress peerPacketSourceAddress;
    private String branch;
    protected String method;
    private int cSeq;
    private TransactionState currentState;
    private int retransmissionTimerLastTickCount;
    private int retransmissionTimerTicksLeft;
    protected int timeoutTimerTicksLeft;
    private Set eventListeners;
    protected From from;
    protected To to;
    protected Event event;
    protected CallID callId;
    private Object wrapper;
    protected int collectionTime;
    protected TimerTask myTimer;
    protected String toTag;
    protected String fromTag;

    public String getBranchId() {
        return this.branch;
    }

    protected SIPTransaction(SIPTransactionStack newParentStack, MessageChannel newEncapsulatedChannel) {
        this.sipStack = newParentStack;
        this.encapsulatedChannel = newEncapsulatedChannel;
        this.peerPort = newEncapsulatedChannel.getPeerPort();
        this.peerAddress = newEncapsulatedChannel.getPeerAddress();
        this.peerInetAddress = newEncapsulatedChannel.getPeerInetAddress();
        this.peerPacketSourcePort = newEncapsulatedChannel.getPeerPacketSourcePort();
        this.peerPacketSourceAddress = newEncapsulatedChannel.getPeerPacketSourceAddress();
        this.peerProtocol = newEncapsulatedChannel.getPeerProtocol();
        if (this.isReliable()) {
            if (this.encapsulatedChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)this.encapsulatedChannel).useCount;
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("use count for encapsulated channel" + this + " " + ((TLSMessageChannel)this.encapsulatedChannel).useCount);
                }
            } else {
                ++((TCPMessageChannel)this.encapsulatedChannel).useCount;
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("use count for encapsulated channel" + this + " " + ((TCPMessageChannel)this.encapsulatedChannel).useCount);
                }
            }
        }
        this.currentState = null;
        this.disableRetransmissionTimer();
        this.disableTimeoutTimer();
        this.eventListeners = Collections.synchronizedSet(new HashSet());
        this.addEventListener(newParentStack);
    }

    public void setOriginalRequest(SIPRequest newOriginalRequest) {
        if (this.originalRequest != null) {
            this.sipStack.removeTransactionHash(this);
        }
        this.originalRequest = newOriginalRequest;
        this.method = newOriginalRequest.getMethod();
        this.from = (From)newOriginalRequest.getFrom();
        this.to = (To)newOriginalRequest.getTo();
        this.toTag = this.to.getTag();
        this.fromTag = this.from.getTag();
        this.callId = (CallID)newOriginalRequest.getCallId();
        this.cSeq = newOriginalRequest.getCSeq().getSequenceNumber();
        this.event = (Event)newOriginalRequest.getHeader("Event");
        this.transactionId = newOriginalRequest.getTransactionId();
        this.originalRequest.setTransaction(this);
        String newBranch = ((Via)newOriginalRequest.getViaHeaders().getFirst()).getBranch();
        if (newBranch != null) {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Setting Branch id : " + newBranch);
            }
            this.setBranch(newBranch);
        } else {
            if (LogWriter.needsLogging) {
                this.sipStack.logWriter.logMessage("Branch id is null - compute TID!" + newOriginalRequest.encode());
            }
            this.setBranch(newOriginalRequest.getTransactionId());
        }
    }

    public SIPRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public Request getRequest() {
        return this.originalRequest;
    }

    public final boolean isInviteTransaction() {
        return this.getMethod().equals("INVITE");
    }

    public final boolean isCancelTransaction() {
        return this.getMethod().equals("CANCEL");
    }

    public final boolean isByeTransaction() {
        return this.getMethod().equals("BYE");
    }

    public MessageChannel getMessageChannel() {
        return this.encapsulatedChannel;
    }

    public final void setBranch(String newBranch) {
        this.branch = newBranch;
    }

    public final String getBranch() {
        if (this.branch == null) {
            this.branch = this.getOriginalRequest().getTopmostVia().getBranch();
        }
        return this.branch;
    }

    public final String getMethod() {
        return this.method;
    }

    public final int getCSeq() {
        return this.cSeq;
    }

    public void setState(TransactionState newState) {
        this.currentState = newState;
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Transaction:setState " + newState + " " + this);
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public TransactionState getState() {
        return this.currentState;
    }

    protected final void enableRetransmissionTimer() {
        this.enableRetransmissionTimer(1);
    }

    protected final void enableRetransmissionTimer(int tickCount) {
        this.retransmissionTimerLastTickCount = this.retransmissionTimerTicksLeft = Math.min(tickCount, 8);
    }

    protected final void disableRetransmissionTimer() {
        this.retransmissionTimerTicksLeft = -1;
    }

    protected final void enableTimeoutTimer(int tickCount) {
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("enableTimeoutTimer " + this + " tickCount " + tickCount + " currentTickCount = " + this.timeoutTimerTicksLeft);
        }
        this.timeoutTimerTicksLeft = tickCount;
    }

    protected final void disableTimeoutTimer() {
        this.timeoutTimerTicksLeft = -1;
    }

    final void fireTimer() {
        if (LogWriter.needsLogging && this instanceof SIPClientTransaction) {
            this.sipStack.getLogWriter().logMessage("fireTimer " + this + " retransmissionTicks " + this.retransmissionTimerTicksLeft);
        }
        if (this.timeoutTimerTicksLeft != -1 && --this.timeoutTimerTicksLeft == 0) {
            this.fireTimeoutTimer();
        }
        if (this.retransmissionTimerTicksLeft != -1 && --this.retransmissionTimerTicksLeft == 0) {
            this.enableRetransmissionTimer(this.retransmissionTimerLastTickCount * 2);
            this.fireRetransmissionTimer();
        }
    }

    public abstract boolean isMessagePartOfTransaction(SIPMessage var1);

    protected abstract void fireRetransmissionTimer();

    protected abstract void fireTimeoutTimer();

    public final boolean isTerminated() {
        return this.getState() == TERMINATED_STATE;
    }

    public String getHost() {
        return this.encapsulatedChannel.getHost();
    }

    public String getKey() {
        return this.encapsulatedChannel.getKey();
    }

    public int getPort() {
        return this.encapsulatedChannel.getPort();
    }

    public SIPMessageStack getSIPStack() {
        return this.sipStack;
    }

    public String getPeerAddress() {
        return this.peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerInetAddress;
    }

    protected String getPeerProtocol() {
        return this.peerProtocol;
    }

    public String getTransport() {
        return this.encapsulatedChannel.getTransport();
    }

    public boolean isReliable() {
        return this.encapsulatedChannel.isReliable();
    }

    public Via getViaHeader() {
        Via channelViaHeader = super.getViaHeader();
        try {
            channelViaHeader.setBranch(this.branch);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return channelViaHeader;
    }

    public void sendMessage(SIPMessage messageToSend) throws IOException {
        this.encapsulatedChannel.sendMessage(messageToSend, this.peerInetAddress, this.peerPort);
    }

    protected void sendMessage(byte[] messageBytes, InetAddress receiverAddress, int receiverPort, boolean retry) throws IOException {
        DatagramSocket sock = ((UDPMessageProcessor)this.encapsulatedChannel.getMessageProcessor()).sock;
        DatagramPacket keepAlivePacket = new DatagramPacket(messageBytes, messageBytes.length, receiverAddress, receiverPort);
        sock.send(keepAlivePacket);
    }

    public void addEventListener(SIPTransactionEventListener newListener) {
        this.eventListeners.add(newListener);
    }

    public void removeEventListener(SIPTransactionEventListener oldListener) {
        this.eventListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void raiseErrorEvent(int errorEventID) {
        SIPTransactionErrorEvent newErrorEvent = new SIPTransactionErrorEvent(this, errorEventID);
        Set set = this.eventListeners;
        synchronized (set) {
            Iterator listenerIterator = this.eventListeners.iterator();
            while (listenerIterator.hasNext()) {
                SIPTransactionEventListener nextListener = (SIPTransactionEventListener)listenerIterator.next();
                nextListener.transactionErrorEvent(newErrorEvent);
            }
        }
        if (errorEventID != 3) {
            this.eventListeners.clear();
            this.setState(TransactionState.TERMINATED);
            if (this instanceof SIPServerTransaction && this.isByeTransaction() && this.dialog != null) {
                this.dialog.setState(3);
            }
        }
    }

    protected boolean IsServerTransaction() {
        return this instanceof SIPServerTransaction;
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public void setDialog(SIPDialog dialog) {
        this.dialog = dialog;
    }

    public int getRetransmitTimer() {
        return 500;
    }

    public String getViaHost() {
        return this.getViaHeader().getHost();
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    public Response getResponse() {
        return this.lastResponse;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public int hashCode() {
        if (this.transactionId == null) {
            return -1;
        }
        return this.transactionId.hashCode();
    }

    public int getViaPort() {
        return this.getViaHeader().getPort();
    }

    public boolean doesCancelMatchTransaction(SIPRequest requestToTest) {
        boolean transactionMatches = false;
        if (this.getOriginalRequest() == null || this.getOriginalRequest().getMethod().equalsIgnoreCase("CANCEL")) {
            return false;
        }
        ViaList viaHeaders = requestToTest.getViaHeaders();
        if (viaHeaders != null) {
            Via topViaHeader = (Via)viaHeaders.getFirst();
            String messageBranch = topViaHeader.getBranch();
            if (messageBranch != null && !messageBranch.startsWith("z9hG4bK")) {
                messageBranch = null;
            }
            if (messageBranch != null && this.getBranch() != null) {
                if (this.getBranch().equalsIgnoreCase(messageBranch) && topViaHeader.getSentBy().equals(((Via)this.getOriginalRequest().getViaHeaders().getFirst()).getSentBy())) {
                    transactionMatches = true;
                    if (LogWriter.needsLogging) {
                        this.sipStack.logWriter.logMessage("returning  true");
                    }
                }
            } else {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("testing against " + this.getOriginalRequest());
                }
                if (this.getOriginalRequest().getRequestURI().equals(requestToTest.getRequestURI()) && this.getOriginalRequest().getTo().equals(requestToTest.getTo()) && this.getOriginalRequest().getFrom().equals(requestToTest.getFrom()) && this.getOriginalRequest().getCallId().getCallId().equals(requestToTest.getCallId().getCallId()) && this.getOriginalRequest().getCSeq().getSequenceNumber() == requestToTest.getCSeq().getSequenceNumber() && topViaHeader.equals(this.getOriginalRequest().getViaHeaders().getFirst())) {
                    transactionMatches = true;
                }
            }
        }
        return transactionMatches;
    }

    public void setRetransmitTimer(int retransmitTimer) {
        throw new UnsupportedOperationException("Feature not supported");
    }

    public void close() {
        this.encapsulatedChannel.close();
        if (LogWriter.needsLogging) {
            this.sipStack.logWriter.logMessage("Closing " + this.encapsulatedChannel);
        }
    }

    public boolean isSecure() {
        return this.encapsulatedChannel.isSecure();
    }

    public MessageProcessor getMessageProcessor() {
        return this.encapsulatedChannel.getMessageProcessor();
    }

    public void setAckSeen() {
        this.isAckSeen = true;
    }

    public boolean ackSeen() {
        return this.isAckSeen;
    }

    public void setEventPending() {
        this.eventPending = true;
    }

    public void clearPending() {
        this.eventPending = false;
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setEncapsulatedChannel(MessageChannel messageChannel) {
        this.encapsulatedChannel = messageChannel;
        this.peerInetAddress = messageChannel.getPeerInetAddress();
        this.peerPort = messageChannel.getPeerPort();
    }

    protected abstract void startTransactionTimer();

    public abstract void processPending();

    class LingerTimer
    extends TimerTask {
        private SIPTransaction transaction;
        private SIPTransactionStack sipStack;

        public LingerTimer(SIPTransaction transaction) {
            this.transaction = transaction;
            this.sipStack = transaction.sipStack;
        }

        public void run() {
            if (this.transaction instanceof SIPClientTransaction) {
                this.transaction.close();
            } else if (this.transaction instanceof ServerTransaction) {
                if (LogWriter.needsLogging) {
                    this.sipStack.logWriter.logMessage("removing" + this.transaction);
                }
                this.sipStack.removeTransaction(this.transaction);
                if (!this.sipStack.cacheServerConnections && this.transaction.encapsulatedChannel instanceof TCPMessageChannel && --((TCPMessageChannel)this.transaction.encapsulatedChannel).useCount == 0) {
                    this.transaction.close();
                } else if (!this.sipStack.cacheServerConnections && this.transaction.encapsulatedChannel instanceof TLSMessageChannel && --((TLSMessageChannel)this.transaction.encapsulatedChannel).useCount == 0) {
                    this.transaction.close();
                } else if (LogWriter.needsLogging && !this.sipStack.cacheServerConnections && this.transaction.isReliable()) {
                    int UseCount = this.transaction.encapsulatedChannel instanceof TCPMessageChannel ? ((TCPMessageChannel)this.transaction.encapsulatedChannel).useCount : ((TLSMessageChannel)this.transaction.encapsulatedChannel).useCount;
                    this.sipStack.logWriter.logMessage("Use Count = " + UseCount);
                }
            }
        }
    }
}

