/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j;

import com.exe4j.runtime.BaseConnectionException;
import com.exe4j.runtime.ControllerInterface;
import com.exe4j.runtime.Exe4JController;
import com.exe4j.runtime.WinLauncher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EventListener;

public class Controller {
    private static ControllerInterface controllerBackend;
    private static StartupListener startupListener;
    private static boolean startupThreadStarted;

    public static void writeMessage(String string) throws ConnectionException {
        try {
            Controller.init();
            controllerBackend.writeMessage(string);
        }
        catch (BaseConnectionException baseConnectionException) {
            throw new ConnectionException(baseConnectionException);
        }
    }

    public static void hide() throws ConnectionException {
        try {
            Controller.init();
            controllerBackend.hide();
        }
        catch (BaseConnectionException baseConnectionException) {
            throw new ConnectionException(baseConnectionException);
        }
    }

    public static void registerStartupListener(StartupListener startupListener) {
        Controller.startupListener = startupListener;
        if (!startupThreadStarted && WinLauncher.PROCESS_COMM_FILE_NAME != null) {
            startupThreadStarted = true;
            new StartupThread().start();
        }
    }

    private static void init() throws BaseConnectionException {
        if (controllerBackend == null) {
            controllerBackend = Exe4JController.getInstance();
        }
    }

    private Controller() {
    }

    static {
        startupThreadStarted = false;
    }

    private static class StartupThread
    extends Thread {
        private File processCommFile = new File(WinLauncher.PROCESS_COMM_FILE_NAME);

        public StartupThread() {
            super("Exe4JStartupThread");
            this.setDaemon(true);
        }

        public void run() {
            long l = 0L;
            int n = 0;
            while (true) {
                if (this.processCommFile.exists() && l != this.processCommFile.lastModified()) {
                    l = this.processCommFile.lastModified();
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.processCommFile), "UTF-16LE"));
                        final String string = bufferedReader.readLine();
                        bufferedReader.close();
                        this.processCommFile.delete();
                        if (startupListener != null) {
                            new Thread(){

                                public void run() {
                                    startupListener.startupPerformed(string);
                                }
                            }.start();
                        }
                        n = 15;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                try {
                    if (n > 0) {
                        StartupThread.sleep(30L);
                        --n;
                        continue;
                    }
                    StartupThread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    public static interface StartupListener
    extends EventListener {
        public void startupPerformed(String var1);
    }

    public static class ConnectionException
    extends Exception {
        private ConnectionException(BaseConnectionException baseConnectionException) {
            super(baseConnectionException.getMessage());
        }
    }
}

