/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPSPDYServerConnector
extends ServerConnector {
    public HTTPSPDYServerConnector(Server server) {
        this(server, Collections.emptyMap());
    }

    public HTTPSPDYServerConnector(Server server, SslContextFactory sslContextFactory) {
        this(server, sslContextFactory, Collections.emptyMap());
    }

    public HTTPSPDYServerConnector(Server server, Map<Short, PushStrategy> pushStrategies) {
        this(server, null, pushStrategies);
    }

    public HTTPSPDYServerConnector(Server server, SslContextFactory sslContextFactory, Map<Short, PushStrategy> pushStrategies) {
        this(server, new HttpConfiguration(), sslContextFactory, pushStrategies);
    }

    public HTTPSPDYServerConnector(Server server, short version, HttpConfiguration httpConfiguration, PushStrategy push) {
        super(server, new ConnectionFactory[]{new HTTPSPDYServerConnectionFactory(version, httpConfiguration, push)});
    }

    public HTTPSPDYServerConnector(Server server, HttpConfiguration config, SslContextFactory sslContextFactory, Map<Short, PushStrategy> pushStrategies) {
        ConnectionFactory[] connectionFactoryArray;
        if (sslContextFactory == null) {
            ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
            connectionFactoryArray = connectionFactoryArray2;
            connectionFactoryArray2[0] = new HttpConnectionFactory(config);
        } else {
            ConnectionFactory[] connectionFactoryArray3 = new ConnectionFactory[4];
            connectionFactoryArray3[0] = new NPNServerConnectionFactory(new String[]{"spdy/3", "spdy/2", "http/1.1"});
            connectionFactoryArray3[1] = new HttpConnectionFactory(config);
            connectionFactoryArray3[2] = new HTTPSPDYServerConnectionFactory(3, config, HTTPSPDYServerConnector.getPushStrategy((short)3, pushStrategies));
            connectionFactoryArray = connectionFactoryArray3;
            connectionFactoryArray3[3] = new HTTPSPDYServerConnectionFactory(2, config, HTTPSPDYServerConnector.getPushStrategy((short)2, pushStrategies));
        }
        super(server, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])connectionFactoryArray));
        NPNServerConnectionFactory npnConnectionFactory = (NPNServerConnectionFactory)this.getConnectionFactory(NPNServerConnectionFactory.class);
        if (npnConnectionFactory != null) {
            npnConnectionFactory.setDefaultProtocol("http/1.1");
        }
    }

    private static PushStrategy getPushStrategy(short version, Map<Short, PushStrategy> pushStrategies) {
        PushStrategy pushStrategy = pushStrategies.get(version);
        if (pushStrategy == null) {
            pushStrategy = new PushStrategy.None();
        }
        return pushStrategy;
    }
}

