/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.clientstate;

import f00f.net.irc.martyr.Command;
import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.Mode;
import f00f.net.irc.martyr.clientstate.Member;
import f00f.net.irc.martyr.modes.channel.OperMode;
import f00f.net.irc.martyr.modes.channel.VoiceMode;
import f00f.net.irc.martyr.util.FullNick;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Channel {
    static Logger log = Logger.getLogger(Channel.class);
    private String name = null;
    private String topic = null;
    private String topicAuthor = null;
    private Date topicDate = null;
    private Date creationDate = null;
    private List<Mode> modes = null;
    private Vector<Member> members;

    public Channel(String chanName) {
        this.name = chanName;
        this.members = new Vector();
        this.modes = new LinkedList<Mode>();
    }

    public String getName() {
        return this.name;
    }

    protected void addMember(Member member) {
        this.members.addElement(member);
    }

    public void addMember(String member, Command why) {
        this.addMember(this.makeMember(member));
    }

    public void addMember(String member, InCommand why) {
        this.addMember(this.makeMember(member));
    }

    public void addMember(FullNick nick, Command why) {
        this.addMember(this.makeMember(nick.getNick()));
    }

    public void addMember(FullNick nick, InCommand why) {
        this.addMember(nick.getNick(), why);
    }

    public void removeMember(String member, InCommand why) {
        this.removeMember(this.makeMember(member));
    }

    public void removeMember(String member, Command why) {
        this.removeMember(this.makeMember(member));
    }

    public void removeMember(FullNick member, Command why) {
        this.removeMember(member, (InCommand)why);
    }

    public void removeMember(FullNick nick, InCommand why) {
        this.removeMember(nick.getNick(), why);
    }

    protected void removeMember(Member compareTo) {
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.members.elementAt(i).equals(compareTo)) continue;
            this.members.removeElementAt(i);
            return;
        }
    }

    public void setMode(Mode mode) {
        if (mode.onePerChannel() && this.modes.contains(mode)) {
            this.modes.remove(mode);
        }
        if (mode.getSign() != Mode.Sign.NEGATIVE && mode.recordInChannel()) {
            this.modes.add(mode);
        }
        if (mode instanceof OperMode) {
            OperMode oMode = (OperMode)mode;
            Member member = this.findMember(oMode.getParam());
            member.setOps(oMode.getSign() == Mode.Sign.POSITIVE);
        } else if (mode instanceof VoiceMode) {
            VoiceMode vMode = (VoiceMode)mode;
            Member member = this.findMember(vMode.getParam());
            member.setVoice(vMode.getSign() == Mode.Sign.POSITIVE);
        }
    }

    public Iterator getModes() {
        return this.modes.iterator();
    }

    public Enumeration getMembers() {
        return this.members.elements();
    }

    public boolean isMemberInChannel(String nick) {
        return this.isMemberInChannel(this.makeMember(nick));
    }

    protected boolean isMemberInChannel(Member member) {
        return this.findMember(member) != null;
    }

    public Member findMember(String nick) {
        return this.findMember(this.makeMember(nick));
    }

    protected Member findMember(Member member) {
        Enumeration membersE = this.getMembers();
        while (membersE.hasMoreElements()) {
            Member memberCompare = (Member)membersE.nextElement();
            if (!memberCompare.equals(member)) continue;
            return memberCompare;
        }
        return null;
    }

    public void setTopic(String topic) {
        log.debug((Object)(this.getName() + ": Topic: " + topic));
        this.topic = topic;
    }

    public String getTopic() {
        return this.topic;
    }

    public Date getTopicDate() {
        return this.topicDate;
    }

    public void setTopicDate(Date date) {
        log.debug((Object)(this.getName() + ": Topic date: " + date));
        this.topicDate = date;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        log.debug((Object)(this.getName() + ": Creation date: " + date));
        this.creationDate = date;
    }

    public String getTopicAuthor() {
        return this.topicAuthor;
    }

    public void setTopicAuthor(String author) {
        log.debug((Object)(this.getName() + ": Topic by: " + author));
        this.topicAuthor = author;
    }

    protected Member makeMember(String nick) {
        return new Member(nick);
    }

    public static boolean isChannel(String str) {
        return str.charAt(0) == '#' || str.charAt(0) == '!' || str.charAt(0) == '&';
    }

    public static boolean areEqual(String one, String two) {
        if (one == null || two == null) {
            return false;
        }
        return one.equalsIgnoreCase(two);
    }
}

