/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util.call;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.sip.communicator.service.gui.call.CallPeerRenderer;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityListener;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import org.jitsi.service.protocol.event.CallPeerSecurityMessageEvent;

public class CallPeerAdapter
extends net.java.sip.communicator.service.protocol.event.CallPeerAdapter
implements CallPeerSecurityListener,
PropertyChangeListener {
    private final CallPeer peer;
    private final CallPeerRenderer renderer;

    public CallPeerAdapter(CallPeer peer, CallPeerRenderer renderer) {
        this.peer = peer;
        this.renderer = renderer;
        this.peer.addCallPeerListener((CallPeerListener)this);
        this.peer.addCallPeerSecurityListener((CallPeerSecurityListener)this);
        this.peer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void dispose() {
        this.peer.removeCallPeerListener((CallPeerListener)this);
        this.peer.removeCallPeerSecurityListener((CallPeerSecurityListener)this);
        this.peer.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void peerDisplayNameChanged(CallPeerChangeEvent ev) {
        if (this.peer.equals(ev.getSourceCallPeer())) {
            this.renderer.setPeerName((String)ev.getNewValue());
        }
    }

    public void peerImageChanged(CallPeerChangeEvent ev) {
        if (this.peer.equals(ev.getSourceCallPeer())) {
            this.renderer.setPeerImage((byte[])ev.getNewValue());
        }
    }

    public void peerStateChanged(CallPeerChangeEvent ev) {
        CallPeer sourcePeer = ev.getSourceCallPeer();
        if (!sourcePeer.equals(this.peer)) {
            return;
        }
        CallPeerState newState = (CallPeerState)ev.getNewValue();
        CallPeerState oldState = (CallPeerState)ev.getOldValue();
        String newStateString = sourcePeer.getState().getLocalizedStateString();
        if (newState == CallPeerState.CONNECTED) {
            if (!CallPeerState.isOnHold((CallPeerState)oldState)) {
                if (!this.renderer.getCallRenderer().isCallTimerStarted()) {
                    this.renderer.getCallRenderer().startCallTimer();
                }
            } else {
                this.renderer.setOnHold(false);
                this.renderer.getCallRenderer().updateHoldButtonState();
            }
        } else if (newState != CallPeerState.DISCONNECTED && newState != CallPeerState.FAILED && CallPeerState.isOnHold((CallPeerState)newState)) {
            this.renderer.setOnHold(true);
            this.renderer.getCallRenderer().updateHoldButtonState();
        }
        this.renderer.setPeerState(oldState, newState, newStateString);
        String reasonString = ev.getReasonString();
        if (reasonString != null) {
            this.renderer.setErrorReason(reasonString);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (propertyName.equals("Mute")) {
            boolean mute = (Boolean)ev.getNewValue();
            this.renderer.setMute(mute);
        }
    }

    public void securityMessageRecieved(CallPeerSecurityMessageEvent ev) {
    }

    public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent ev) {
        if (this.peer.equals(ev.getSource())) {
            this.renderer.securityNegotiationStarted(ev);
        }
    }

    public void securityOff(CallPeerSecurityOffEvent ev) {
        if (this.peer.equals(ev.getSource())) {
            this.renderer.securityOff(ev);
        }
    }

    public void securityOn(CallPeerSecurityOnEvent ev) {
        if (this.peer.equals(ev.getSource())) {
            this.renderer.securityOn(ev);
        }
    }

    public void securityTimeout(CallPeerSecurityTimeoutEvent ev) {
        if (this.peer.equals(ev.getSource())) {
            this.renderer.securityTimeout(ev);
        }
    }
}

