/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;

public class ClassLoaderDump
implements Dumpable {
    final ClassLoader _loader;

    public ClassLoaderDump(ClassLoader loader) {
        this._loader = loader;
    }

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        if (this._loader == null) {
            out.append("No ClassLoader\n");
        } else {
            out.append(String.valueOf(this._loader)).append("\n");
            Object parent = this._loader.getParent();
            if (parent != null) {
                if (!(parent instanceof Dumpable)) {
                    parent = new ClassLoaderDump((ClassLoader)parent);
                }
                if (this._loader instanceof URLClassLoader) {
                    ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])((URLClassLoader)this._loader).getURLs()), Collections.singleton(parent)});
                } else {
                    ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Collections.singleton(parent)});
                }
            }
        }
    }
}

