/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JInternalFrame;

public class RemoveLaunchApplication
extends AbstractTool {
    static {
        RemoveLaunchApplication.addVersion("$Id: RemoveLaunchApplication.java,v 1.4 2005/11/29 21:05:02 blowagie Exp $");
    }

    public RemoveLaunchApplication() {
        this.menuoptions = 3;
        this.arguments.add(new FileArgument(this, "srcfile", "The file from which you want to remove Launch Application actions", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the cleaned up version of the original PDF has to be written", true, new PdfFilter()));
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Remove Launch Applications", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Remove Launch Applications OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            File src = (File)this.getValue("srcfile");
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            File dest = (File)this.getValue("destfile");
            PdfReader reader = new PdfReader(src.getAbsolutePath());
            int i = 1;
            while (i < reader.getXrefSize()) {
                PdfDictionary d;
                PdfObject o = reader.getPdfObject(i);
                if (o instanceof PdfDictionary && (o = (d = (PdfDictionary)o).get(PdfName.A)) != null) {
                    PdfDictionary l;
                    if (o instanceof PdfDictionary) {
                        l = (PdfDictionary)o;
                    } else {
                        PRIndirectReference r = (PRIndirectReference)o;
                        l = (PdfDictionary)reader.getPdfObject(r.getNumber());
                    }
                    PdfName n = (PdfName)l.get(PdfName.S);
                    if (PdfName.LAUNCH.equals(n)) {
                        if (l.get(PdfName.F) != null) {
                            System.out.println("Removed: " + l.get(PdfName.F));
                            l.remove(PdfName.F);
                        }
                        if (l.get(PdfName.WIN) != null) {
                            System.out.println("Removed: " + l.get(PdfName.WIN));
                            l.remove(PdfName.WIN);
                        }
                        l.put(PdfName.S, PdfName.JAVASCRIPT);
                        l.put(PdfName.JS, new PdfString("app.alert('Launch Application Action removed by iText');\r"));
                    }
                }
                ++i;
            }
            PdfStamper stamper = new PdfStamper(reader, new FileOutputStream(dest));
            stamper.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void valueHasChanged(ToolArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] args) {
        RemoveLaunchApplication tool = new RemoveLaunchApplication();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setArguments(args);
        tool.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }
}

