/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.LinkedList;
import java.util.List;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlRegion;

public class OveruseDetector {
    private static final int kMinFramePeriodHistoryLength = 60;
    private static final int kOverUsingTimeThreshold = 100;
    private double avgNoise;
    private final FrameSample currentFrame = new FrameSample();
    private final double[][] E;
    private final double[] Eh = new double[2];
    private final double[] h = new double[2];
    private BandwidthUsage hypothesis = BandwidthUsage.kBwNormal;
    private final double[][] IKh = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
    private final double[] K = new double[2];
    private int numOfDeltas;
    private double offset;
    private final OverUseDetectorOptions options;
    private int overUseCounter;
    private long packetTimeMs;
    private final FrameSample prevFrame = new FrameSample();
    private double prevOffset;
    private final double[] processNoise;
    private double slope;
    private double threshold;
    private final double[] timeDeltas = new double[2];
    private double timeOverUsing = -1.0;
    private final List<Double> tsDeltaHist = new LinkedList<Double>();
    private double varNoise;

    private static double[][] clone(double[][] matrix) {
        int length = matrix.length;
        double[][] clone = new double[length][];
        for (int i = 0; i < length; ++i) {
            clone[i] = (double[])matrix[i].clone();
        }
        return clone;
    }

    private static boolean isInOrderTimestamp(long timestamp, long prevTimestamp) {
        long timestampDiff = timestamp - prevTimestamp;
        return timestampDiff < 0x80000000L;
    }

    public OveruseDetector() {
        this(new OverUseDetectorOptions());
    }

    public OveruseDetector(OverUseDetectorOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        this.avgNoise = this.options.initialAvgNoise;
        this.offset = this.options.initialOffset;
        this.processNoise = (double[])this.options.initialProcessNoise.clone();
        this.slope = this.options.initialSlope;
        this.threshold = this.options.initialThreshold;
        this.varNoise = this.options.initialVarNoise;
        this.E = OveruseDetector.clone(this.options.initialE);
    }

    private BandwidthUsage detect(double tsDelta) {
        if (this.numOfDeltas < 2) {
            return BandwidthUsage.kBwNormal;
        }
        double T = (double)Math.min(this.numOfDeltas, 60) * this.offset;
        if (Math.abs(T) > this.threshold) {
            if (this.offset > 0.0) {
                this.timeOverUsing = this.timeOverUsing == -1.0 ? tsDelta / 2.0 : (this.timeOverUsing += tsDelta);
                ++this.overUseCounter;
                if (this.timeOverUsing > 100.0 && this.overUseCounter > 1 && this.offset >= this.prevOffset) {
                    this.timeOverUsing = 0.0;
                    this.overUseCounter = 0;
                    this.hypothesis = BandwidthUsage.kBwOverusing;
                }
            } else {
                this.timeOverUsing = -1.0;
                this.overUseCounter = 0;
                this.hypothesis = BandwidthUsage.kBwUnderusing;
            }
        } else {
            this.timeOverUsing = -1.0;
            this.overUseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwNormal;
        }
        return this.hypothesis;
    }

    private double getCurrentDrift() {
        return 1.0;
    }

    public double getNoiseVar() {
        return this.varNoise;
    }

    public long getPacketTimeMs() {
        return this.packetTimeMs;
    }

    public BandwidthUsage getState() {
        return this.hypothesis;
    }

    private void getTimeDeltas(FrameSample currentFrame, FrameSample prevFrame, double[] timeDeltas) {
        double tsDelta;
        ++this.numOfDeltas;
        if (this.numOfDeltas > 1000) {
            this.numOfDeltas = 1000;
        }
        if (currentFrame.timestampMs == -1L) {
            long timestampDiff = currentFrame.timestamp - prevFrame.timestamp;
            tsDelta = (double)timestampDiff / 90.0;
        } else {
            tsDelta = currentFrame.timestampMs - prevFrame.timestampMs;
        }
        long tDelta = currentFrame.completeTimeMs - prevFrame.completeTimeMs;
        timeDeltas[0] = tDelta;
        timeDeltas[1] = tsDelta;
    }

    private boolean isPacketInOrder(long timestamp, long timestampMs) {
        if (this.currentFrame.timestampMs == -1L && this.currentFrame.timestamp > -1L) {
            return OveruseDetector.isInOrderTimestamp(timestamp, this.currentFrame.timestamp);
        }
        if (this.currentFrame.timestampMs > 0L) {
            return timestampMs > this.currentFrame.timestampMs;
        }
        return true;
    }

    public void setPacketTimeMs(long packetTimeMs) {
        this.packetTimeMs = packetTimeMs;
    }

    public void setRateControlRegion(RateControlRegion region) {
        switch (region) {
            case kRcMaxUnknown: {
                this.threshold = this.options.initialThreshold;
                break;
            }
            case kRcAboveMax: 
            case kRcNearMax: {
                this.threshold = this.options.initialThreshold / 2.0;
            }
        }
    }

    private void switchTimeBase() {
        this.currentFrame.size = 0L;
        this.currentFrame.completeTimeMs = -1L;
        this.currentFrame.timestamp = -1L;
        this.prevFrame.copy(this.currentFrame);
    }

    public void update(int packetSize, long timestampMs, long rtpTimestamp, long arrivalTimeMs) {
        boolean newTimestamp;
        boolean bl = newTimestamp = rtpTimestamp != this.currentFrame.timestamp;
        if (timestampMs >= 0L) {
            if (this.prevFrame.timestampMs == -1L && this.currentFrame.timestampMs == -1L) {
                this.switchTimeBase();
            }
            boolean bl2 = newTimestamp = timestampMs != this.currentFrame.timestampMs;
        }
        if (this.currentFrame.timestamp == -1L) {
            this.currentFrame.timestamp = rtpTimestamp;
            this.currentFrame.timestampMs = timestampMs;
        } else {
            if (!this.isPacketInOrder(rtpTimestamp, timestampMs)) {
                return;
            }
            if (newTimestamp) {
                if (this.prevFrame.completeTimeMs >= 0L) {
                    this.getTimeDeltas(this.currentFrame, this.prevFrame, this.timeDeltas);
                    this.updateKalman((long)this.timeDeltas[0], this.timeDeltas[1], this.currentFrame.size, this.prevFrame.size);
                }
                this.prevFrame.copy(this.currentFrame);
                this.currentFrame.timestamp = rtpTimestamp;
                this.currentFrame.timestampMs = timestampMs;
                this.currentFrame.size = 0L;
            }
        }
        this.currentFrame.size += (long)packetSize;
        this.currentFrame.completeTimeMs = arrivalTimeMs;
    }

    private void updateKalman(long tDelta, double tsDelta, long frameSize, long prevFrameSize) {
        double minFramePeriod = this.updateMinFramePeriod(tsDelta);
        double drift = this.getCurrentDrift();
        double tTsDelta = (double)tDelta - tsDelta / drift;
        double fsDelta = (double)frameSize - (double)prevFrameSize;
        double scaleFactor = minFramePeriod / 33.333333333333336;
        double[] dArray = this.E[0];
        dArray[0] = dArray[0] + this.processNoise[0] * scaleFactor;
        double[] dArray2 = this.E[1];
        dArray2[1] = dArray2[1] + this.processNoise[1] * scaleFactor;
        if (this.hypothesis == BandwidthUsage.kBwOverusing && this.offset < this.prevOffset || this.hypothesis == BandwidthUsage.kBwUnderusing && this.offset > this.prevOffset) {
            double[] dArray3 = this.E[1];
            dArray3[1] = dArray3[1] + 10.0 * this.processNoise[1] * scaleFactor;
        }
        double[] h = this.h;
        double[] Eh = this.Eh;
        h[0] = fsDelta;
        h[1] = 1.0;
        Eh[0] = this.E[0][0] * h[0] + this.E[0][1] * h[1];
        Eh[1] = this.E[1][0] * h[0] + this.E[1][1] * h[1];
        double residual = tTsDelta - this.slope * h[0] - this.offset;
        boolean stableState = (double)Math.min(this.numOfDeltas, 60) * Math.abs(this.offset) < this.threshold;
        double threeTimesSqrtVarNoise = 3.0 * Math.sqrt(this.varNoise);
        double residualForUpdateNoiseEstimate = Math.abs(residual) < threeTimesSqrtVarNoise ? residual : threeTimesSqrtVarNoise;
        this.updateNoiseEstimate(residualForUpdateNoiseEstimate, minFramePeriod, stableState);
        double denom = this.varNoise + h[0] * Eh[0] + h[1] * Eh[1];
        double[] K = this.K;
        double[][] IKh = this.IKh;
        K[0] = Eh[0] / denom;
        K[1] = Eh[1] / denom;
        IKh[0][0] = 1.0 - K[0] * h[0];
        IKh[0][1] = -K[0] * h[1];
        IKh[1][0] = -K[1] * h[0];
        IKh[1][1] = 1.0 - K[1] * h[1];
        double e00 = this.E[0][0];
        double e01 = this.E[0][1];
        this.E[0][0] = e00 * IKh[0][0] + this.E[1][0] * IKh[0][1];
        this.E[0][1] = e01 * IKh[0][0] + this.E[1][1] * IKh[0][1];
        this.E[1][0] = e00 * IKh[1][0] + this.E[1][0] * IKh[1][1];
        this.E[1][1] = e01 * IKh[1][0] + this.E[1][1] * IKh[1][1];
        this.slope += K[0] * residual;
        this.prevOffset = this.offset;
        this.offset += K[1] * residual;
        this.detect(tsDelta);
    }

    private double updateMinFramePeriod(double tsDelta) {
        double minFramePeriod = tsDelta;
        if (this.tsDeltaHist.size() >= 60) {
            this.tsDeltaHist.remove(0);
        }
        for (Double d : this.tsDeltaHist) {
            minFramePeriod = Math.min(d, minFramePeriod);
        }
        this.tsDeltaHist.add(tsDelta);
        return minFramePeriod;
    }

    private void updateNoiseEstimate(double residual, double tsDelta, boolean stableState) {
        if (!stableState) {
            return;
        }
        double alpha = 0.01;
        if (this.numOfDeltas > 300) {
            alpha = 0.002;
        }
        double beta = Math.pow(1.0 - alpha, tsDelta * 30.0 / 1000.0);
        this.avgNoise = beta * this.avgNoise + (1.0 - beta) * residual;
        this.varNoise = beta * this.varNoise + (1.0 - beta) * (this.avgNoise - residual) * (this.avgNoise - residual);
        if (this.varNoise < 1.0E-7) {
            this.varNoise = 1.0E-7;
        }
    }

    private static class FrameSample {
        public long completeTimeMs = -1L;
        public long size = 0L;
        public long timestamp = -1L;
        public long timestampMs = -1L;

        private FrameSample() {
        }

        public void copy(FrameSample source) {
            this.completeTimeMs = source.completeTimeMs;
            this.size = source.size;
            this.timestamp = source.timestamp;
            this.timestampMs = source.timestampMs;
        }
    }
}

