/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp.termination.strategies;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;
import org.jitsi.impl.neomedia.rtcp.RTCPFBPacket;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.AbstractRTCPTerminationStrategy;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCache;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCacheProcessor;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.FeedbackCacheUpdater;
import org.jitsi.impl.neomedia.rtcp.termination.strategies.ReceiverFeedbackFilter;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.Transformer;

public class BasicRTCPTerminationStrategy
extends AbstractRTCPTerminationStrategy {
    private final FeedbackCacheProcessor feedbackCacheProcessor;
    private final FeedbackCache feedbackCache = new FeedbackCache();

    public BasicRTCPTerminationStrategy() {
        this.feedbackCacheProcessor = new FeedbackCacheProcessor(this.feedbackCache);
        this.feedbackCacheProcessor.setPercentile(70);
        this.setTransformerChain(new Transformer[]{new FeedbackCacheUpdater(this.feedbackCache), new ReceiverFeedbackFilter()});
    }

    @Override
    public RTCPPacket[] makeReports() {
        RTCPPacket[] bestReceiverFeedback;
        RTCPReportBlock[] reports;
        RTCPTransmitter rtcpTransmitter = this.getRTCPReportBuilder().getRTCPTransmitter();
        if (rtcpTransmitter == null) {
            throw new IllegalStateException("rtcpTransmitter is not set");
        }
        RTPTranslator t = this.getRTPTranslator();
        if (t == null || !(t instanceof RTPTranslatorImpl)) {
            return new RTCPPacket[0];
        }
        int localSSRC = (int)((RTPTranslatorImpl)t).getLocalSSRC(null);
        Vector<RTCPPacket> packets = new Vector<RTCPPacket>();
        long time = System.currentTimeMillis();
        RTCPReportBlock[] firstrep = reports = this.makeReceiverReports(time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        packets.addElement(new RTCPRRPacket(localSSRC, firstrep));
        if (firstrep != reports) {
            for (int offset = 31; offset < reports.length; offset += 31) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                RTCPRRPacket rTCPRRPacket = new RTCPRRPacket(localSSRC, firstrep);
                packets.addElement(rTCPRRPacket);
            }
        }
        if ((bestReceiverFeedback = this.feedbackCacheProcessor.makeReports(localSSRC)) != null && bestReceiverFeedback.length != 0) {
            for (RTCPPacket packet : bestReceiverFeedback) {
                if (packet.type != 206 || !(packet instanceof RTCPFBPacket) || ((RTCPFBPacket)packet).fmt != 15) continue;
                packets.add(packet);
            }
        }
        Object[] objectArray = new RTCPPacket[packets.size()];
        packets.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, RTCPReportBlock> makeReceiverReportsMap(long time) {
        HashMap<Integer, RTCPReportBlock> reports = new HashMap<Integer, RTCPReportBlock>();
        RTCPTransmitter rtcpTransmitter = this.getRTCPReportBuilder().getRTCPTransmitter();
        if (rtcpTransmitter == null) {
            throw new IllegalStateException("rtcpTransmitter is not set");
        }
        Enumeration<SSRCInfo> elements = rtcpTransmitter.cache.cache.elements();
        while (elements.hasMoreElements()) {
            SSRCInfo info;
            SSRCInfo sSRCInfo = info = elements.nextElement();
            synchronized (sSRCInfo) {
                if (!info.ours) {
                    RTCPReportBlock receiverReport = info.makeReceiverReport(time);
                    reports.put(info.ssrc, receiverReport);
                }
            }
        }
        return reports;
    }

    private RTCPReportBlock[] makeReceiverReports(long time) {
        Collection<RTCPReportBlock> reports = this.makeReceiverReportsMap(time).values();
        return reports.toArray(new RTCPReportBlock[reports.size()]);
    }
}

