/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.rest;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.AbstractPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.GracefulShutdownIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.SourcePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.DtlsFingerprintPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ParameterPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.PayloadTypePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RawUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RemoteCandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtcpmuxPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.service.neomedia.MediaDirection;
import org.jivesoftware.smack.packet.PacketExtension;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JSONDeserializer {
    public static void deserializeAbstractPacketExtensionAttributes(JSONObject jsonObject, AbstractPacketExtension abstractPacketExtension) {
        for (Map.Entry e : jsonObject.entrySet()) {
            Object value;
            String name;
            Object key = e.getKey();
            if (key == null || (name = key.toString()) == null || (value = e.getValue()) instanceof JSONObject || value instanceof JSONArray) continue;
            abstractPacketExtension.setAttribute(name, value);
        }
    }

    public static <T extends CandidatePacketExtension> T deserializeCandidate(JSONObject candidate, Class<T> candidateIQClass, IceUdpTransportPacketExtension transportIQ) {
        CandidatePacketExtension candidateIQ;
        if (candidate == null) {
            candidateIQ = null;
        } else {
            try {
                candidateIQ = (CandidatePacketExtension)candidateIQClass.newInstance();
            }
            catch (IllegalAccessException iae) {
                throw new UndeclaredThrowableException(iae);
            }
            catch (InstantiationException ie) {
                throw new UndeclaredThrowableException(ie);
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(candidate, (AbstractPacketExtension)candidateIQ);
            transportIQ.addChildExtension((PacketExtension)candidateIQ);
        }
        return (T)candidateIQ;
    }

    public static void deserializeCandidates(JSONArray candidates, IceUdpTransportPacketExtension transportIQ) {
        if (candidates != null && !candidates.isEmpty()) {
            for (Object candidate : candidates) {
                JSONDeserializer.deserializeCandidate((JSONObject)candidate, CandidatePacketExtension.class, transportIQ);
            }
        }
    }

    public static ColibriConferenceIQ.Channel deserializeChannel(JSONObject channel, ColibriConferenceIQ.Content contentIQ) {
        ColibriConferenceIQ.Channel channelIQ;
        if (channel == null) {
            channelIQ = null;
        } else {
            Integer i;
            Object direction = channel.get((Object)"direction");
            Object lastN = channel.get((Object)"last-n");
            Object receivingSimulcastLayer = channel.get((Object)"receive-simulcast-layer");
            Object payloadTypes = channel.get((Object)"payload-types");
            Object rtpLevelRelayType = channel.get((Object)"rtp-level-relay-type");
            Object sources = channel.get((Object)"sources");
            Object sourceGroups = channel.get((Object)"ssrc-groups");
            Object ssrcs = channel.get((Object)"ssrcs");
            channelIQ = new ColibriConferenceIQ.Channel();
            JSONDeserializer.deserializeChannelCommon(channel, (ColibriConferenceIQ.ChannelCommon)channelIQ);
            if (direction != null) {
                channelIQ.setDirection(MediaDirection.parseString((String)direction.toString()));
            }
            if (lastN != null) {
                i = lastN instanceof Integer ? (Integer)lastN : (lastN instanceof Number ? Integer.valueOf(((Number)lastN).intValue()) : Integer.valueOf(lastN.toString()));
                channelIQ.setLastN(i);
            }
            if (receivingSimulcastLayer != null) {
                i = receivingSimulcastLayer instanceof Integer ? (Integer)receivingSimulcastLayer : (receivingSimulcastLayer instanceof Number ? Integer.valueOf(((Number)receivingSimulcastLayer).intValue()) : Integer.valueOf(receivingSimulcastLayer.toString()));
                channelIQ.setReceivingSimulcastLayer(i);
            }
            if (payloadTypes != null) {
                JSONDeserializer.deserializePayloadTypes((JSONArray)payloadTypes, channelIQ);
            }
            if (rtpLevelRelayType != null) {
                channelIQ.setRTPLevelRelayType(rtpLevelRelayType.toString());
            }
            if (sources != null) {
                JSONDeserializer.deserializeSources((JSONArray)sources, channelIQ);
            }
            if (sourceGroups != null) {
                JSONDeserializer.deserializeSourceGroups((JSONArray)sourceGroups, channelIQ);
            }
            if (ssrcs != null) {
                JSONDeserializer.deserializeSSRCs((JSONArray)ssrcs, channelIQ);
            }
            contentIQ.addChannel(channelIQ);
        }
        return channelIQ;
    }

    public static ColibriConferenceIQ.ChannelBundle deserializeChannelBundle(JSONObject channelBundle, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.ChannelBundle channelBundleIQ;
        if (channelBundle == null) {
            channelBundleIQ = null;
        } else {
            Object id = channelBundle.get((Object)"id");
            Object transport = channelBundle.get((Object)"transport");
            channelBundleIQ = new ColibriConferenceIQ.ChannelBundle(id == null ? null : id.toString());
            if (transport != null) {
                JSONDeserializer.deserializeTransport((JSONObject)transport, channelBundleIQ);
            }
            conferenceIQ.addChannelBundle(channelBundleIQ);
        }
        return channelBundleIQ;
    }

    public static void deserializeChannelBundles(JSONArray channelBundles, ColibriConferenceIQ conferenceIQ) {
        if (channelBundles != null && !channelBundles.isEmpty()) {
            for (Object channelBundle : channelBundles) {
                JSONDeserializer.deserializeChannelBundle((JSONObject)channelBundle, conferenceIQ);
            }
        }
    }

    public static void deserializeChannelCommon(JSONObject channel, ColibriConferenceIQ.ChannelCommon channelIQ) {
        int i;
        Object id = channel.get((Object)"id");
        Object channelBundleId = channel.get((Object)"channel-bundle-id");
        Object endpoint = channel.get((Object)"endpoint");
        Object expire = channel.get((Object)"expire");
        Object initiator = channel.get((Object)"initiator");
        Object transport = channel.get((Object)"transport");
        if (id != null) {
            channelIQ.setID(id.toString());
        }
        if (channelBundleId != null) {
            channelIQ.setChannelBundleId(channelBundleId.toString());
        }
        if (endpoint != null) {
            channelIQ.setEndpoint(endpoint.toString());
        }
        if (expire != null && (i = expire instanceof Number ? ((Number)expire).intValue() : Integer.parseInt(expire.toString())) != -1) {
            channelIQ.setExpire(i);
        }
        if (initiator != null) {
            Boolean b = initiator instanceof Boolean ? (Boolean)initiator : Boolean.valueOf(initiator.toString());
            channelIQ.setInitiator(b);
        }
        if (transport != null) {
            JSONDeserializer.deserializeTransport((JSONObject)transport, channelIQ);
        }
    }

    public static void deserializeChannels(JSONArray channels, ColibriConferenceIQ.Content contentIQ) {
        if (channels != null && !channels.isEmpty()) {
            for (Object channel : channels) {
                JSONDeserializer.deserializeChannel((JSONObject)channel, contentIQ);
            }
        }
    }

    public static ColibriConferenceIQ deserializeConference(JSONObject conference) {
        ColibriConferenceIQ conferenceIQ;
        if (conference == null) {
            conferenceIQ = null;
        } else {
            Object id = conference.get((Object)"id");
            Object contents = conference.get((Object)"contents");
            Object channelBundles = conference.get((Object)"channel-bundles");
            Object recording = conference.get((Object)"recording");
            Object strategy = conference.get((Object)"rtcp-termination-strategy");
            Object shutdownExt = conference.get((Object)"graceful-shutdown");
            conferenceIQ = new ColibriConferenceIQ();
            if (id != null) {
                conferenceIQ.setID(id.toString());
            }
            if (contents != null) {
                JSONDeserializer.deserializeContents((JSONArray)contents, conferenceIQ);
            }
            if (channelBundles != null) {
                JSONDeserializer.deserializeChannelBundles((JSONArray)channelBundles, conferenceIQ);
            }
            if (recording != null) {
                JSONDeserializer.deserializeRecording((JSONObject)recording, conferenceIQ);
            }
            if (strategy != null) {
                JSONDeserializer.deserializeRTCPTerminationStrategy((JSONObject)strategy, conferenceIQ);
            }
            if (shutdownExt != null) {
                conferenceIQ.setGracefulShutdown(true);
            }
        }
        return conferenceIQ;
    }

    private static void deserializeRTCPTerminationStrategy(JSONObject strategy, ColibriConferenceIQ conferenceIQ) {
        if (strategy != null & conferenceIQ != null) {
            String name;
            Object attrName = strategy.get((Object)"name");
            if (attrName == null || (name = attrName.toString()).length() == 0) {
                return;
            }
            ColibriConferenceIQ.RTCPTerminationStrategy strategyIQ = new ColibriConferenceIQ.RTCPTerminationStrategy();
            strategyIQ.setName(name);
            conferenceIQ.setRTCPTerminationStrategy(strategyIQ);
        }
    }

    public static ColibriConferenceIQ.Content deserializeContent(JSONObject content, ColibriConferenceIQ conferenceIQ) {
        ColibriConferenceIQ.Content contentIQ;
        if (content == null) {
            contentIQ = null;
        } else {
            Object name = content.get((Object)"name");
            Object channels = content.get((Object)"channels");
            Object sctpConnections = content.get((Object)"sctpconnections");
            contentIQ = conferenceIQ.getOrCreateContent(name == null ? null : name.toString());
            if (channels != null) {
                JSONDeserializer.deserializeChannels((JSONArray)channels, contentIQ);
            }
            if (sctpConnections != null) {
                JSONDeserializer.deserializeSctpConnections((JSONArray)sctpConnections, contentIQ);
            }
            conferenceIQ.addContent(contentIQ);
        }
        return contentIQ;
    }

    public static void deserializeContents(JSONArray contents, ColibriConferenceIQ conferenceIQ) {
        if (contents != null && !contents.isEmpty()) {
            for (Object content : contents) {
                JSONDeserializer.deserializeContent((JSONObject)content, conferenceIQ);
            }
        }
    }

    public static DtlsFingerprintPacketExtension deserializeFingerprint(JSONObject fingerprint, IceUdpTransportPacketExtension transportIQ) {
        DtlsFingerprintPacketExtension fingerprintIQ;
        if (fingerprint == null) {
            fingerprintIQ = null;
        } else {
            Object theFingerprint = fingerprint.get((Object)"fingerprint");
            fingerprintIQ = new DtlsFingerprintPacketExtension();
            if (theFingerprint != null) {
                fingerprintIQ.setFingerprint(theFingerprint.toString());
            }
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(fingerprint, (AbstractPacketExtension)fingerprintIQ);
            fingerprintIQ.removeAttribute("fingerprint");
            transportIQ.addChildExtension((PacketExtension)fingerprintIQ);
        }
        return fingerprintIQ;
    }

    public static void deserializeFingerprints(JSONArray fingerprints, IceUdpTransportPacketExtension transportIQ) {
        if (fingerprints != null && !fingerprints.isEmpty()) {
            for (Object fingerprint : fingerprints) {
                JSONDeserializer.deserializeFingerprint((JSONObject)fingerprint, transportIQ);
            }
        }
    }

    public static void deserializeParameters(JSONObject parameters, PayloadTypePacketExtension payloadTypeIQ) {
        if (parameters != null) {
            for (Map.Entry e : parameters.entrySet()) {
                Object name = e.getKey();
                Object value = e.getValue();
                if (name == null && value == null) continue;
                payloadTypeIQ.addParameter(new ParameterPacketExtension(name == null ? null : name.toString(), value == null ? null : value.toString()));
            }
        }
    }

    public static PayloadTypePacketExtension deserializePayloadType(JSONObject payloadType, ColibriConferenceIQ.Channel channelIQ) {
        PayloadTypePacketExtension payloadTypeIQ;
        if (payloadType == null) {
            payloadTypeIQ = null;
        } else {
            Object parameters = payloadType.get((Object)"parameters");
            payloadTypeIQ = new PayloadTypePacketExtension();
            JSONDeserializer.deserializeAbstractPacketExtensionAttributes(payloadType, (AbstractPacketExtension)payloadTypeIQ);
            if (parameters != null) {
                JSONDeserializer.deserializeParameters((JSONObject)parameters, payloadTypeIQ);
            }
            channelIQ.addPayloadType(payloadTypeIQ);
        }
        return payloadTypeIQ;
    }

    public static void deserializePayloadTypes(JSONArray payloadTypes, ColibriConferenceIQ.Channel channelIQ) {
        if (payloadTypes != null && !payloadTypes.isEmpty()) {
            for (Object payloadType : payloadTypes) {
                JSONDeserializer.deserializePayloadType((JSONObject)payloadType, channelIQ);
            }
        }
    }

    public static void deserializeRecording(JSONObject recording, ColibriConferenceIQ conferenceIQ) {
        Object directory;
        Object state = recording.get((Object)"state");
        if (state == null) {
            return;
        }
        Boolean b = state instanceof Boolean ? (Boolean)state : Boolean.valueOf(state.toString());
        ColibriConferenceIQ.Recording recordingIQ = new ColibriConferenceIQ.Recording(b.booleanValue());
        Object token = recording.get((Object)"token");
        if (token != null) {
            recordingIQ.setToken(token.toString());
        }
        if ((directory = recording.get((Object)"directory")) != null) {
            recordingIQ.setDirectory(directory.toString());
        }
        conferenceIQ.setRecording(recordingIQ);
    }

    public static ColibriConferenceIQ.SctpConnection deserializeSctpConnection(JSONObject sctpConnection, ColibriConferenceIQ.Content contentIQ) {
        ColibriConferenceIQ.SctpConnection sctpConnectionIQ;
        if (sctpConnection == null) {
            sctpConnectionIQ = null;
        } else {
            Object port = sctpConnection.get((Object)"port");
            sctpConnectionIQ = new ColibriConferenceIQ.SctpConnection();
            JSONDeserializer.deserializeChannelCommon(sctpConnection, (ColibriConferenceIQ.ChannelCommon)sctpConnectionIQ);
            if (port != null) {
                Integer i = port instanceof Integer ? (Integer)port : (port instanceof Number ? Integer.valueOf(((Number)port).intValue()) : Integer.valueOf(port.toString()));
                sctpConnectionIQ.setPort(i.intValue());
            }
            contentIQ.addSctpConnection(sctpConnectionIQ);
        }
        return sctpConnectionIQ;
    }

    public static void deserializeSctpConnections(JSONArray sctpConnections, ColibriConferenceIQ.Content contentIQ) {
        if (sctpConnections != null && !sctpConnections.isEmpty()) {
            for (Object sctpConnection : sctpConnections) {
                JSONDeserializer.deserializeSctpConnection((JSONObject)sctpConnection, contentIQ);
            }
        }
    }

    public static GracefulShutdownIQ deserializeShutdownIQ(JSONObject requestJSONObject) {
        return requestJSONObject.get((Object)"graceful-shutdown") != null ? new GracefulShutdownIQ() : null;
    }

    public static SourcePacketExtension deserializeSource(Object source) {
        SourcePacketExtension sourceIQ;
        if (source == null) {
            sourceIQ = null;
        } else {
            long ssrc;
            try {
                ssrc = JSONDeserializer.deserializeSSRC(source);
            }
            catch (NumberFormatException nfe) {
                ssrc = -1L;
            }
            if (ssrc == -1L) {
                sourceIQ = null;
            } else {
                sourceIQ = new SourcePacketExtension();
                sourceIQ.setSSRC(ssrc);
            }
        }
        return sourceIQ;
    }

    public static SourcePacketExtension deserializeSource(Object source, ColibriConferenceIQ.Channel channelIQ) {
        SourcePacketExtension sourcePacketExtension = JSONDeserializer.deserializeSource(source);
        if (sourcePacketExtension != null) {
            channelIQ.addSource(sourcePacketExtension);
        }
        return sourcePacketExtension;
    }

    public static SourceGroupPacketExtension deserializeSourceGroup(Object sourceGroup, ColibriConferenceIQ.Channel channelIQ) {
        SourceGroupPacketExtension sourceGroupIQ;
        if (sourceGroup == null || !(sourceGroup instanceof JSONObject)) {
            sourceGroupIQ = null;
        } else {
            JSONObject sourceGroupJSONObject = (JSONObject)sourceGroup;
            Object semantics = sourceGroupJSONObject.get((Object)"semantics");
            if (semantics != null && semantics instanceof String && ((String)semantics).length() != 0) {
                Object sourcesObject = sourceGroupJSONObject.get((Object)"sources");
                if (sourcesObject != null && sourcesObject instanceof JSONArray && ((JSONArray)sourcesObject).size() != 0) {
                    JSONArray sourcesJSONArray = (JSONArray)sourcesObject;
                    ArrayList<SourcePacketExtension> sourcePacketExtensions = new ArrayList<SourcePacketExtension>();
                    for (Object source : sourcesJSONArray) {
                        SourcePacketExtension sourcePacketExtension = JSONDeserializer.deserializeSource(source);
                        if (sourcePacketExtension == null) continue;
                        sourcePacketExtensions.add(sourcePacketExtension);
                    }
                    sourceGroupIQ = new SourceGroupPacketExtension();
                    sourceGroupIQ.setSemantics((String)semantics);
                    sourceGroupIQ.addSources(sourcePacketExtensions);
                    channelIQ.addSourceGroup(sourceGroupIQ);
                } else {
                    sourceGroupIQ = null;
                }
            } else {
                sourceGroupIQ = null;
            }
        }
        return sourceGroupIQ;
    }

    public static void deserializeSourceGroups(JSONArray sourceGroups, ColibriConferenceIQ.Channel channelIQ) {
        if (sourceGroups != null && !sourceGroups.isEmpty()) {
            for (Object sourceGroup : sourceGroups) {
                JSONDeserializer.deserializeSourceGroup(sourceGroup, channelIQ);
            }
        }
    }

    public static void deserializeSources(JSONArray sources, ColibriConferenceIQ.Channel channelIQ) {
        if (sources != null && !sources.isEmpty()) {
            for (Object source : sources) {
                JSONDeserializer.deserializeSource(source, channelIQ);
            }
        }
    }

    public static int deserializeSSRC(Object o) throws NumberFormatException {
        int i = 0;
        if (o != null) {
            String s;
            i = o instanceof Number ? ((Number)o).intValue() : ((s = o.toString()).startsWith("-") ? Integer.parseInt(s) : (int)Long.parseLong(s));
        }
        return i;
    }

    public static void deserializeSSRCs(JSONArray ssrcs, ColibriConferenceIQ.Channel channelIQ) {
        if (ssrcs != null && !ssrcs.isEmpty()) {
            for (Object ssrc : ssrcs) {
                int ssrcIQ;
                try {
                    ssrcIQ = JSONDeserializer.deserializeSSRC(ssrc);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                channelIQ.addSSRC(ssrcIQ);
            }
        }
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport) {
        Object transportIQ;
        if (transport == null) {
            transportIQ = null;
        } else {
            Object xmlns = transport.get((Object)"xmlns");
            Object fingerprints = transport.get((Object)"fingerprints");
            Object candidateList = transport.get((Object)"candidates");
            Object remoteCandidate = transport.get((Object)"remote-candidate");
            Object rtcpMux = transport.get((Object)"rtcp-mux");
            transportIQ = "urn:xmpp:jingle:transports:ice-udp:1".equals(xmlns) ? new IceUdpTransportPacketExtension() : ("urn:xmpp:jingle:transports:raw-udp:1".equals(xmlns) ? new RawUdpTransportPacketExtension() : null);
            if (transportIQ != null) {
                boolean b;
                JSONDeserializer.deserializeAbstractPacketExtensionAttributes(transport, (AbstractPacketExtension)transportIQ);
                if (fingerprints != null) {
                    JSONDeserializer.deserializeFingerprints((JSONArray)fingerprints, transportIQ);
                }
                if (candidateList != null) {
                    JSONDeserializer.deserializeCandidates((JSONArray)candidateList, transportIQ);
                }
                if (remoteCandidate != null) {
                    JSONDeserializer.deserializeCandidate((JSONObject)remoteCandidate, RemoteCandidatePacketExtension.class, transportIQ);
                }
                if (rtcpMux != null && (b = rtcpMux instanceof Boolean ? (Boolean)rtcpMux : Boolean.parseBoolean(rtcpMux.toString()))) {
                    transportIQ.addChildExtension((PacketExtension)new RtcpmuxPacketExtension());
                }
            }
        }
        return transportIQ;
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport, ColibriConferenceIQ.ChannelBundle channelBundleIQ) {
        IceUdpTransportPacketExtension transportIQ = JSONDeserializer.deserializeTransport(transport);
        if (transportIQ != null) {
            channelBundleIQ.setTransport(transportIQ);
        }
        return transportIQ;
    }

    public static IceUdpTransportPacketExtension deserializeTransport(JSONObject transport, ColibriConferenceIQ.ChannelCommon channelIQ) {
        IceUdpTransportPacketExtension transportIQ = JSONDeserializer.deserializeTransport(transport);
        if (transportIQ != null) {
            channelIQ.setTransport(transportIQ);
        }
        return transportIQ;
    }

    private JSONDeserializer() {
    }
}

