/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableSerializer;
import com.hazelcast.nio.serialization.PortableWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class DefaultPortableWriter
implements PortableWriter {
    private final PortableSerializer serializer;
    private final ClassDefinition cd;
    private final BufferObjectDataOutput out;
    private final int begin;
    private final int offset;
    private final Set<String> writtenFields;
    private boolean raw;

    public DefaultPortableWriter(PortableSerializer serializer, BufferObjectDataOutput out, ClassDefinition cd) throws IOException {
        this.serializer = serializer;
        this.out = out;
        this.cd = cd;
        this.writtenFields = new HashSet<String>(cd.getFieldCount());
        this.begin = out.position();
        out.writeZeroBytes(4);
        this.offset = out.position();
        int fieldIndexesLength = (cd.getFieldCount() + 1) * 4;
        out.writeZeroBytes(fieldIndexesLength);
    }

    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public void writeInt(String fieldName, int value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeInt(value);
    }

    @Override
    public void writeLong(String fieldName, long value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeLong(value);
    }

    @Override
    public void writeUTF(String fieldName, String str) throws IOException {
        this.setPosition(fieldName);
        this.out.writeUTF(str);
    }

    @Override
    public void writeBoolean(String fieldName, boolean value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeBoolean(value);
    }

    @Override
    public void writeByte(String fieldName, byte value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeByte(value);
    }

    @Override
    public void writeChar(String fieldName, int value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeChar(value);
    }

    @Override
    public void writeDouble(String fieldName, double value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeDouble(value);
    }

    @Override
    public void writeFloat(String fieldName, float value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeFloat(value);
    }

    @Override
    public void writeShort(String fieldName, short value) throws IOException {
        this.setPosition(fieldName);
        this.out.writeShort(value);
    }

    @Override
    public void writePortable(String fieldName, Portable portable) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName);
        boolean isNull = portable == null;
        this.out.writeBoolean(isNull);
        if (!isNull) {
            this.checkPortableAttributes(fd, portable);
            this.serializer.write((ObjectDataOutput)this.out, portable);
        }
    }

    private void checkPortableAttributes(FieldDefinition fd, Portable portable) {
        if (fd.getFactoryId() != portable.getFactoryId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported!  Expected factory-id: " + fd.getFactoryId() + ", Actual factory-id: " + portable.getFactoryId());
        }
        if (fd.getClassId() != portable.getClassId()) {
            throw new HazelcastSerializationException("Wrong Portable type! Generic portable types are not supported! Expected class-id: " + fd.getClassId() + ", Actual class-id: " + portable.getClassId());
        }
    }

    @Override
    public void writeNullPortable(String fieldName, int factoryId, int classId) throws IOException {
        this.setPosition(fieldName);
        this.out.writeBoolean(true);
    }

    @Override
    public void writeByteArray(String fieldName, byte[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeByteArray(values);
    }

    @Override
    public void writeCharArray(String fieldName, char[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeCharArray(values);
    }

    @Override
    public void writeIntArray(String fieldName, int[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeIntArray(values);
    }

    @Override
    public void writeLongArray(String fieldName, long[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeLongArray(values);
    }

    @Override
    public void writeDoubleArray(String fieldName, double[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeDoubleArray(values);
    }

    @Override
    public void writeFloatArray(String fieldName, float[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeFloatArray(values);
    }

    @Override
    public void writeShortArray(String fieldName, short[] values) throws IOException {
        this.setPosition(fieldName);
        this.out.writeShortArray(values);
    }

    @Override
    public void writePortableArray(String fieldName, Portable[] portables) throws IOException {
        FieldDefinition fd = this.setPosition(fieldName);
        int len = portables == null ? 0 : portables.length;
        this.out.writeInt(len);
        if (len > 0) {
            int offset = this.out.position();
            this.out.writeZeroBytes(len * 4);
            for (int i = 0; i < portables.length; ++i) {
                Portable portable = portables[i];
                this.checkPortableAttributes(fd, portable);
                int position = this.out.position();
                this.out.writeInt(offset + i * 4, position);
                this.serializer.write((ObjectDataOutput)this.out, portable);
            }
        }
    }

    private FieldDefinition setPosition(String fieldName) throws IOException {
        if (this.raw) {
            throw new HazelcastSerializationException("Cannot write Portable fields after getRawDataOutput() is called!");
        }
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
        }
        if (!this.writtenFields.add(fieldName)) {
            throw new HazelcastSerializationException("Field '" + fieldName + "' has already been written!");
        }
        int pos = this.out.position();
        int index = fd.getIndex();
        this.out.writeInt(this.offset + index * 4, pos);
        return fd;
    }

    @Override
    public ObjectDataOutput getRawDataOutput() throws IOException {
        if (!this.raw) {
            int pos = this.out.position();
            int index = this.cd.getFieldCount();
            this.out.writeInt(this.offset + index * 4, pos);
        }
        this.raw = true;
        return this.out;
    }

    void end() throws IOException {
        int position = this.out.position();
        this.out.writeInt(this.begin, position);
    }
}

