/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.socket.ServerSocketChannel;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannel;
import org.jboss.netty.channel.socket.nio.NioServerSocketPipelineSink;
import org.jboss.netty.channel.socket.nio.NioWorker;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.SelectorUtil;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.internal.ExecutorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NioServerSocketChannelFactory
implements ServerSocketChannelFactory {
    final Executor bossExecutor;
    private final WorkerPool<NioWorker> workerPool;
    private final ChannelSink sink;

    public NioServerSocketChannelFactory() {
        this((Executor)Executors.newCachedThreadPool(), Executors.newCachedThreadPool());
    }

    public NioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        this(bossExecutor, new NioWorkerPool(workerExecutor, workerCount, true));
    }

    public NioServerSocketChannelFactory(Executor bossExecutor, WorkerPool<NioWorker> workerPool) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerPool == null) {
            throw new NullPointerException("workerPool");
        }
        this.bossExecutor = bossExecutor;
        this.workerPool = workerPool;
        this.sink = new NioServerSocketPipelineSink(workerPool);
    }

    @Override
    public ServerSocketChannel newChannel(ChannelPipeline pipeline) {
        return new NioServerSocketChannel(this, pipeline, this.sink);
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor);
        if (this.workerPool instanceof ExternalResourceReleasable) {
            ((ExternalResourceReleasable)((Object)this.workerPool)).releaseExternalResources();
        }
    }
}

