/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.frames.RstStreamFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;

public class RstStreamBodyParser
extends ControlFrameBodyParser {
    private final ControlFrameParser controlFrameParser;
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;
    private int statusCode;

    public RstStreamBodyParser(ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block6: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.STATUS_CODE;
                        continue block6;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block6;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block6;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.STATUS_CODE;
                    continue block6;
                }
                case STATUS_CODE: {
                    if (buffer.remaining() >= 4) {
                        this.statusCode = buffer.getInt();
                        this.onRstStream();
                        return true;
                    }
                    this.state = State.STATUS_CODE_BYTES;
                    this.cursor = 4;
                    continue block6;
                }
                case STATUS_CODE_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.statusCode += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block6;
                    this.onRstStream();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void onRstStream() {
        RstStreamFrame frame = new RstStreamFrame(this.controlFrameParser.getVersion(), this.streamId, this.statusCode);
        this.controlFrameParser.onControlFrame(frame);
        this.reset();
    }

    private void reset() {
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
        this.statusCode = 0;
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        STATUS_CODE,
        STATUS_CODE_BYTES;

    }
}

