/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.packet;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import net.jcip.annotations.NotThreadSafe;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

@NotThreadSafe
public class StreamError {
    private static final String ERROR_NAMESPACE = "urn:ietf:params:xml:ns:xmpp-streams";
    private static DocumentFactory docFactory = DocumentFactory.getInstance();
    private Element element;

    public StreamError(Condition condition) {
        this.element = docFactory.createElement(docFactory.createQName("error", "stream", "http://etherx.jabber.org/streams"));
        this.setCondition(condition);
    }

    public StreamError(Condition condition, String text) {
        this.element = docFactory.createElement(docFactory.createQName("error", "stream", "http://etherx.jabber.org/streams"));
        this.setCondition(condition);
        this.setText(text, null);
    }

    public StreamError(Condition condition, String text, String language) {
        this.element = docFactory.createElement(docFactory.createQName("error", "stream", "http://etherx.jabber.org/streams"));
        this.setCondition(condition);
        this.setText(text, language);
    }

    public StreamError(Element element) {
        this.element = element;
    }

    public Condition getCondition() {
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!el.getNamespaceURI().equals(ERROR_NAMESPACE) || el.getName().equals("text")) continue;
            return Condition.fromXMPP(el.getName());
        }
        return null;
    }

    public void setCondition(Condition condition) {
        if (condition == null) {
            throw new NullPointerException("Condition cannot be null");
        }
        Element conditionElement = null;
        Iterator i = this.element.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            if (!el.getNamespaceURI().equals(ERROR_NAMESPACE) || el.getName().equals("text")) continue;
            conditionElement = el;
        }
        if (conditionElement != null) {
            this.element.remove(conditionElement);
        }
        conditionElement = docFactory.createElement(condition.toXMPP(), ERROR_NAMESPACE);
        this.element.add(conditionElement);
    }

    public String getText() {
        return this.element.elementText("text");
    }

    public void setText(String text) {
        this.setText(text, null);
    }

    public void setText(String text, String language) {
        Element textElement = this.element.element("text");
        if (text == null) {
            if (textElement != null) {
                this.element.remove(textElement);
            }
            return;
        }
        if (textElement == null) {
            textElement = docFactory.createElement("text", ERROR_NAMESPACE);
            if (language != null) {
                textElement.addAttribute(QName.get((String)"lang", (String)"xml", (String)"http://www.w3.org/XML/1998/namespace"), language);
            }
            this.element.add(textElement);
        }
        textElement.setText(text);
    }

    public String getTextLanguage() {
        Element textElement = this.element.element("text");
        if (textElement != null) {
            return textElement.attributeValue(QName.get((String)"lang", (String)"xml", (String)"http://www.w3.org/XML/1998/namespace"));
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toXML() {
        return this.element.asXML();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)out, OutputFormat.createPrettyPrint());
        try {
            writer.write(this.element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Condition {
        bad_format("bad-format"),
        bad_namespace_prefix("bad-namespace-prefix"),
        conflict("conflict"),
        connection_timeout("connection-timeout"),
        host_gone("host-gone"),
        host_unknown("host-unknown"),
        improper_addressing("improper-addressing"),
        internal_server_error("internal-server-error"),
        invalid_from("invalid-from"),
        invalid_id("invalid-id"),
        invalid_namespace("invalid-namespace"),
        invalid_xml("invalid-xml"),
        not_authorized("not-authorized"),
        policy_violation("policy-violation"),
        remote_connection_failed("remote-connection-failed"),
        resource_constraint("resource-constraint"),
        restricted_xml("restricted-xml"),
        see_other_host("see-other-host"),
        system_shutdown("system-shutdown"),
        undefined_condition("undefined-condition"),
        unsupported_encoding("unsupported-encoding"),
        unsupported_stanza_type("unsupported-stanza-type"),
        unsupported_version("unsupported-version"),
        xml_not_well_formed("xml-not-well-formed"),
        not_well_formed("not-well-formed");

        private String value;

        public static Condition fromXMPP(String condition) {
            if (condition == null) {
                throw new NullPointerException();
            }
            condition = condition.toLowerCase();
            if (bad_format.toXMPP().equals(condition)) {
                return bad_format;
            }
            if (bad_namespace_prefix.toXMPP().equals(condition)) {
                return bad_namespace_prefix;
            }
            if (conflict.toXMPP().equals(condition)) {
                return conflict;
            }
            if (connection_timeout.toXMPP().equals(condition)) {
                return connection_timeout;
            }
            if (host_gone.toXMPP().equals(condition)) {
                return host_gone;
            }
            if (host_unknown.toXMPP().equals(condition)) {
                return host_unknown;
            }
            if (improper_addressing.toXMPP().equals(condition)) {
                return improper_addressing;
            }
            if (internal_server_error.toXMPP().equals(condition)) {
                return internal_server_error;
            }
            if (invalid_from.toXMPP().equals(condition)) {
                return invalid_from;
            }
            if (invalid_id.toXMPP().equals(condition)) {
                return invalid_id;
            }
            if (invalid_namespace.toXMPP().equals(condition)) {
                return invalid_namespace;
            }
            if (invalid_xml.toXMPP().equals(condition)) {
                return invalid_xml;
            }
            if (not_authorized.toXMPP().equals(condition)) {
                return not_authorized;
            }
            if (policy_violation.toXMPP().equals(condition)) {
                return policy_violation;
            }
            if (remote_connection_failed.toXMPP().equals(condition)) {
                return remote_connection_failed;
            }
            if (resource_constraint.toXMPP().equals(condition)) {
                return resource_constraint;
            }
            if (restricted_xml.toXMPP().equals(condition)) {
                return restricted_xml;
            }
            if (see_other_host.toXMPP().equals(condition)) {
                return see_other_host;
            }
            if (system_shutdown.toXMPP().equals(condition)) {
                return system_shutdown;
            }
            if (undefined_condition.toXMPP().equals(condition)) {
                return undefined_condition;
            }
            if (unsupported_encoding.toXMPP().equals(condition)) {
                return unsupported_encoding;
            }
            if (unsupported_stanza_type.toXMPP().equals(condition)) {
                return unsupported_stanza_type;
            }
            if (unsupported_version.toXMPP().equals(condition)) {
                return unsupported_version;
            }
            if (xml_not_well_formed.toXMPP().equals(condition)) {
                return xml_not_well_formed;
            }
            if (not_well_formed.toXMPP().equals(condition)) {
                return not_well_formed;
            }
            throw new IllegalArgumentException("Condition invalid:" + condition);
        }

        private Condition(String value) {
            this.value = value;
        }

        public String toXMPP() {
            return this.value;
        }
    }
}

