/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayInputStream
extends InputStream
implements DataInput {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public HsqlByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public HsqlByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.mark = n;
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = this.read(byArray, n + i, n2 - i);
            if (n3 >= 0) continue;
            throw new EOFException();
        }
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        if (this.count - this.pos < 2) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        return (short)((n << 8) + n2);
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + n;
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + n);
    }

    public int readInt() throws IOException {
        if (this.count - this.pos < 4) {
            this.pos = this.count;
            throw new EOFException();
        }
        int n = this.buf[this.pos++] & 0xFF;
        int n2 = this.buf[this.pos++] & 0xFF;
        int n3 = this.buf[this.pos++] & 0xFF;
        int n4 = this.buf[this.pos++] & 0xFF;
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public String readLine() throws IOException {
        throw new RuntimeException("not implemented.");
    }

    public String readUTF() throws IOException {
        int n = this.readUnsignedShort();
        if (this.pos + n >= this.count) {
            throw new EOFException();
        }
        String string = StringConverter.readUTF(this.buf, this.pos, n);
        this.pos += n;
        return string;
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void close() throws IOException {
    }
}

