/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerMediaHandlerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberAccountIDImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.JingleNodesHarvester;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.TransportInfoSender;
import net.java.sip.communicator.impl.protocol.jabber.TransportManagerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidatePacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.CandidateType;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.ContentPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.IceUdpTransportPacketExtension;
import net.java.sip.communicator.impl.protocol.jabber.extensions.jingle.RtpDescriptionPacketExtension;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.StunServerDescriptor;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.service.protocol.media.TransportManager;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.PortTracker;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.ice.harvest.UPNPHarvester;
import org.ice4j.security.LongTermCredential;
import org.jitsi.service.neomedia.DefaultStreamConnector;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.packet.PacketExtension;
import org.xmpp.jnodes.smack.SmackServiceNode;

public class IceUdpTransportManager
extends TransportManagerJabberImpl
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(IceUdpTransportManager.class);
    private static final int[] COMPONENT_IDS = new int[]{1, 2};
    protected List<ContentPacketExtension> cpeList;
    protected final Agent iceAgent = this.createIceAgent();
    protected static final String DEFAULT_STUN_SERVER_ADDRESS = "stun.jitsi.net";
    protected static final int DEFAULT_STUN_SERVER_PORT = 3478;

    public IceUdpTransportManager(CallPeerJabberImpl callPeer) {
        super(callPeer);
        this.iceAgent.addStateChangeListener((PropertyChangeListener)this);
    }

    protected Agent createIceAgent() {
        SmackServiceNode serviceNode;
        long startGatheringHarvesterTime = System.currentTimeMillis();
        CallPeerJabberImpl peer = (CallPeerJabberImpl)this.getCallPeer();
        ProtocolProviderServiceJabberImpl provider = (ProtocolProviderServiceJabberImpl)peer.getProtocolProvider();
        NetworkAddressManagerService namSer = IceUdpTransportManager.getNetAddrMgr();
        boolean atLeastOneStunServer = false;
        Agent agent = namSer.createIceAgent();
        agent.setControlling(!peer.isInitiator());
        JabberAccountIDImpl accID = (JabberAccountIDImpl)provider.getAccountID();
        if (accID.isStunServerDiscoveryEnabled()) {
            String username = org.jivesoftware.smack.util.StringUtils.parseName((String)provider.getOurJID());
            String password = JabberActivator.getProtocolProviderFactory().loadPassword((AccountID)accID);
            UserCredentials credentials = provider.getUserCredentials();
            if (credentials != null) {
                password = credentials.getPasswordAsString();
            }
            if (password == null) {
                credentials = new UserCredentials();
                credentials.setUserName(accID.getUserID());
                credentials = provider.getAuthority().obtainCredentials(accID.getDisplayName(), credentials, 0);
                if (credentials == null) {
                    return null;
                }
                char[] pass = credentials.getPassword();
                if (pass == null) {
                    return null;
                }
                password = new String(pass);
                if (credentials.isPasswordPersistent()) {
                    JabberActivator.getProtocolProviderFactory().storePassword((AccountID)accID, password);
                }
            }
            StunCandidateHarvester autoHarvester = namSer.discoverStunServer(accID.getService(), StringUtils.getUTF8Bytes((String)username), StringUtils.getUTF8Bytes((String)password));
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Auto discovered harvester is " + autoHarvester));
            }
            if (autoHarvester != null) {
                atLeastOneStunServer = true;
                agent.addCandidateHarvester((CandidateHarvester)autoHarvester);
            }
        }
        for (StunServerDescriptor desc : accID.getStunServers()) {
            TransportAddress addr = new TransportAddress(desc.getAddress(), desc.getPort(), Transport.UDP);
            if (addr.getAddress() == null) {
                logger.info((Object)("Unresolved address for " + addr));
                continue;
            }
            Object harvester = desc.isTurnSupported() ? new TurnCandidateHarvester(addr, new LongTermCredential(desc.getUsername(), desc.getPassword())) : new StunCandidateHarvester(addr);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Adding pre-configured harvester " + harvester));
            }
            atLeastOneStunServer = true;
            agent.addCandidateHarvester((CandidateHarvester)harvester);
        }
        if (!atLeastOneStunServer && accID.isUseDefaultStunServer()) {
            TransportAddress addr = new TransportAddress(DEFAULT_STUN_SERVER_ADDRESS, 3478, Transport.UDP);
            agent.addCandidateHarvester((CandidateHarvester)new StunCandidateHarvester(addr));
        }
        if (accID.isJingleNodesRelayEnabled() && (serviceNode = provider.getJingleNodesServiceNode()) != null) {
            agent.addCandidateHarvester((CandidateHarvester)new JingleNodesHarvester(serviceNode));
        }
        if (accID.isUPNPEnabled()) {
            agent.addCandidateHarvester((CandidateHarvester)new UPNPHarvester());
        }
        long stopGatheringHarvesterTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            long gatheringHarvesterTime = stopGatheringHarvesterTime - startGatheringHarvesterTime;
            logger.info((Object)("End gathering harvester within " + gatheringHarvesterTime + " ms"));
        }
        return agent;
    }

    @Override
    protected StreamConnector doCreateStreamConnector(MediaType mediaType) throws OperationFailedException {
        TransportManagerJabberImpl delegate = this.findTransportManagerEstablishingConnectivityWithJitsiVideobridge();
        if (delegate != null && delegate != this) {
            return delegate.doCreateStreamConnector(mediaType);
        }
        DatagramSocket[] streamConnectorSockets = this.getStreamConnectorSockets(mediaType);
        return streamConnectorSockets == null ? super.doCreateStreamConnector(mediaType) : new DefaultStreamConnector(streamConnectorSockets[0], streamConnectorSockets[1]);
    }

    public StreamConnector getStreamConnector(MediaType mediaType) throws OperationFailedException {
        DatagramSocket[] streamConnectorSockets;
        StreamConnector streamConnector = super.getStreamConnector(mediaType);
        if (streamConnector != null && (streamConnectorSockets = this.getStreamConnectorSockets(mediaType)) != null && (streamConnector.getDataSocket() != streamConnectorSockets[0] || streamConnector.getControlSocket() != streamConnectorSockets[1])) {
            this.closeStreamConnector(mediaType);
            streamConnector = super.getStreamConnector(mediaType);
        }
        return streamConnector;
    }

    private DatagramSocket[] getStreamConnectorSockets(MediaType mediaType) {
        IceMediaStream stream = this.iceAgent.getStream(mediaType.toString());
        if (stream != null) {
            DatagramSocket[] streamConnectorSockets = new DatagramSocket[COMPONENT_IDS.length];
            int streamConnectorSocketCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                DatagramSocket streamConnectorSocket;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamConnectorSocket = selectedPair.getLocalCandidate().getDatagramSocket()) == null) continue;
                streamConnectorSockets[i] = streamConnectorSocket;
                ++streamConnectorSocketCount;
            }
            if (streamConnectorSocketCount > 0) {
                return streamConnectorSockets;
            }
        }
        return null;
    }

    @Override
    public MediaStreamTarget getStreamTarget(MediaType mediaType) {
        TransportManagerJabberImpl delegate = this.findTransportManagerEstablishingConnectivityWithJitsiVideobridge();
        if (delegate != null && delegate != this) {
            return delegate.getStreamTarget(mediaType);
        }
        IceMediaStream stream = this.iceAgent.getStream(mediaType.toString());
        MediaStreamTarget streamTarget = null;
        if (stream != null) {
            InetSocketAddress[] streamTargetAddresses = new InetSocketAddress[COMPONENT_IDS.length];
            int streamTargetAddressCount = 0;
            for (int i = 0; i < COMPONENT_IDS.length; ++i) {
                TransportAddress streamTargetAddress;
                CandidatePair selectedPair;
                Component component = stream.getComponent(COMPONENT_IDS[i]);
                if (component == null || (selectedPair = component.getSelectedPair()) == null || (streamTargetAddress = selectedPair.getRemoteCandidate().getTransportAddress()) == null) continue;
                streamTargetAddresses[i] = streamTargetAddress;
                ++streamTargetAddressCount;
            }
            if (streamTargetAddressCount > 0) {
                streamTarget = new MediaStreamTarget(streamTargetAddresses[0], streamTargetAddresses[1]);
            }
        }
        return streamTarget;
    }

    @Override
    public String getXmlNamespace() {
        return "urn:xmpp:jingle:transports:ice-udp:1";
    }

    @Override
    protected PacketExtension createTransportPacketExtension() {
        return new IceUdpTransportPacketExtension();
    }

    @Override
    protected PacketExtension startCandidateHarvest(ContentPacketExtension theirContent, ContentPacketExtension ourContent, TransportInfoSender transportInfoSender, String media) throws OperationFailedException {
        PacketExtension pe;
        if (transportInfoSender == null) {
            pe = this.createTransportForStartCandidateHarvest(media);
        } else {
            pe = this.createTransportPacketExtension();
            ContentPacketExtension transportInfoContent = new ContentPacketExtension();
            for (String name : ourContent.getAttributeNames()) {
                Object value = ourContent.getAttribute(name);
                if (value == null) continue;
                transportInfoContent.setAttribute(name, value);
            }
            transportInfoContent.addChildExtension(this.createTransportForStartCandidateHarvest(media));
            LinkedList<ContentPacketExtension> transportInfoContents = new LinkedList<ContentPacketExtension>();
            transportInfoContents.add(transportInfoContent);
            transportInfoSender.sendTransportInfo(transportInfoContents);
        }
        return pe;
    }

    @Override
    public void startCandidateHarvest(List<ContentPacketExtension> theirOffer, List<ContentPacketExtension> ourAnswer, TransportInfoSender transportInfoSender) throws OperationFailedException {
        this.cpeList = ourAnswer;
        super.startCandidateHarvest(theirOffer, ourAnswer, transportInfoSender);
    }

    protected PacketExtension createTransport(IceMediaStream stream) {
        IceUdpTransportPacketExtension transport = new IceUdpTransportPacketExtension();
        Agent iceAgent = stream.getParentAgent();
        transport.setUfrag(iceAgent.getLocalUfrag());
        transport.setPassword(iceAgent.getLocalPassword());
        for (Component component : stream.getComponents()) {
            for (Candidate candidate : component.getLocalCandidates()) {
                transport.addCandidate(this.createCandidate(candidate));
            }
        }
        return transport;
    }

    @Override
    protected PacketExtension createTransport(String media) throws OperationFailedException {
        IceMediaStream iceStream = this.iceAgent.getStream(media);
        if (iceStream == null) {
            iceStream = this.createIceStream(media);
        }
        return this.createTransport(iceStream);
    }

    private CandidatePacketExtension createCandidate(Candidate<?> candidate) {
        CandidatePacketExtension packet = new CandidatePacketExtension();
        packet.setFoundation(candidate.getFoundation());
        Component component = candidate.getParentComponent();
        packet.setComponent(component.getComponentID());
        packet.setProtocol(candidate.getTransport().toString());
        packet.setPriority(candidate.getPriority());
        packet.setGeneration(component.getParentStream().getParentAgent().getGeneration());
        TransportAddress transportAddress = candidate.getTransportAddress();
        packet.setID(this.getNextID());
        packet.setIP(transportAddress.getHostAddress());
        packet.setPort(transportAddress.getPort());
        packet.setType(CandidateType.valueOf(candidate.getType().toString()));
        TransportAddress relAddr = candidate.getRelatedAddress();
        if (relAddr != null) {
            packet.setRelAddr(relAddr.getHostAddress());
            packet.setRelPort(relAddr.getPort());
        }
        packet.setNetwork(0);
        return packet;
    }

    protected IceMediaStream createIceStream(String media) throws OperationFailedException {
        IceMediaStream stream;
        PortTracker portTracker;
        try {
            portTracker = IceUdpTransportManager.getPortTracker((String)media);
            stream = IceUdpTransportManager.getNetAddrMgr().createIceStream(portTracker.getPort(), media, this.iceAgent);
        }
        catch (Exception ex) {
            throw new OperationFailedException("Failed to initialize stream " + media, 4, (Throwable)ex);
        }
        try {
            portTracker.setNextPort(1 + ((LocalCandidate)stream.getComponent(2).getLocalCandidates().get(0)).getTransportAddress().getPort());
        }
        catch (Throwable t) {
            logger.debug((Object)"Determining next port didn't work: ", t);
        }
        return stream;
    }

    @Override
    public List<ContentPacketExtension> wrapupCandidateHarvest() {
        return this.cpeList;
    }

    private static NetworkAddressManagerService getNetAddrMgr() {
        return JabberActivator.getNetworkAddressManagerService();
    }

    @Override
    public synchronized boolean startConnectivityEstablishment(Iterable<ContentPacketExtension> remote) {
        LinkedHashMap<String, IceUdpTransportPacketExtension> map = new LinkedHashMap<String, IceUdpTransportPacketExtension>();
        for (ContentPacketExtension content : remote) {
            ContentPacketExtension localContent;
            IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
            RtpDescriptionPacketExtension description = content.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            if (description == null && this.cpeList != null && (localContent = IceUdpTransportManager.findContentByName(this.cpeList, content.getName())) != null) {
                description = localContent.getFirstChildOfType(RtpDescriptionPacketExtension.class);
            }
            if (description == null) continue;
            String media = description.getMedia();
            map.put(media, transport);
        }
        if (((CallPeerJabberImpl)this.getCallPeer()).isJitsiVideobridge()) {
            this.sendTransportInfoToJitsiVideobridge(map);
            return false;
        }
        return this.startConnectivityEstablishment(map);
    }

    @Override
    protected synchronized boolean startConnectivityEstablishment(Map<String, IceUdpTransportPacketExtension> remote) {
        boolean iceAgentStateIsRunning = IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState());
        if (iceAgentStateIsRunning && logger.isInfoEnabled()) {
            logger.info((Object)"Update ICE remote candidates");
        }
        int generation = this.iceAgent.getGeneration();
        boolean startConnectivityEstablishment = false;
        for (Map.Entry<String, IceUdpTransportPacketExtension> e : remote.entrySet()) {
            String password;
            IceUdpTransportPacketExtension transport = e.getValue();
            List<CandidatePacketExtension> candidates = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
            if (iceAgentStateIsRunning && candidates.size() == 0) {
                return false;
            }
            Collections.sort(candidates);
            String media = e.getKey();
            IceMediaStream stream = this.iceAgent.getStream(media);
            String ufrag = transport.getUfrag();
            if (ufrag != null) {
                stream.setRemoteUfrag(ufrag);
            }
            if ((password = transport.getPassword()) != null) {
                stream.setRemotePassword(password);
            }
            for (CandidatePacketExtension candidate : candidates) {
                int relPort;
                if (candidate.getGeneration() != generation) continue;
                Component component = stream.getComponent(candidate.getComponent());
                TransportAddress relatedAddress = null;
                String relAddr = candidate.getRelAddr();
                if (relAddr != null && (relPort = candidate.getRelPort()) != -1) {
                    relatedAddress = new TransportAddress(relAddr, relPort, Transport.parse((String)candidate.getProtocol()));
                }
                RemoteCandidate relatedCandidate = component.findRemoteCandidate(relatedAddress);
                RemoteCandidate remoteCandidate = new RemoteCandidate(new TransportAddress(candidate.getIP(), candidate.getPort(), Transport.parse((String)candidate.getProtocol())), component, org.ice4j.ice.CandidateType.parse((String)candidate.getType().toString()), candidate.getFoundation(), (long)candidate.getPriority(), relatedCandidate);
                if (iceAgentStateIsRunning) {
                    component.addUpdateRemoteCandidates(remoteCandidate);
                    continue;
                }
                component.addRemoteCandidate(remoteCandidate);
                startConnectivityEstablishment = true;
            }
        }
        if (iceAgentStateIsRunning) {
            for (IceMediaStream stream : this.iceAgent.getStreams()) {
                for (Component component : stream.getComponents()) {
                    component.updateRemoteCandidates();
                }
            }
        } else if (startConnectivityEstablishment) {
            for (IceMediaStream stream : this.iceAgent.getStreams()) {
                for (Component component : stream.getComponents()) {
                    if (component.getRemoteCandidateCount() >= 1) continue;
                    startConnectivityEstablishment = false;
                    break;
                }
                if (startConnectivityEstablishment) continue;
                break;
            }
            if (startConnectivityEstablishment) {
                this.iceAgent.startConnectivityEstablishment();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrapupConnectivityEstablishment() throws OperationFailedException {
        TransportManagerJabberImpl delegate = this.findTransportManagerEstablishingConnectivityWithJitsiVideobridge();
        if (delegate == null || delegate == this) {
            final Object iceProcessingStateSyncRoot = new Object();
            PropertyChangeListener stateChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Object newValue = evt.getNewValue();
                    if (IceProcessingState.COMPLETED.equals(newValue) || IceProcessingState.FAILED.equals(newValue) || IceProcessingState.TERMINATED.equals(newValue)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("ICE " + newValue));
                        }
                        Agent iceAgent = (Agent)evt.getSource();
                        iceAgent.removeStateChangeListener((PropertyChangeListener)this);
                        if (iceAgent == IceUdpTransportManager.this.iceAgent) {
                            Object object = iceProcessingStateSyncRoot;
                            synchronized (object) {
                                iceProcessingStateSyncRoot.notify();
                            }
                        }
                    }
                }
            };
            this.iceAgent.addStateChangeListener(stateChangeListener);
            boolean interrupted = false;
            Object object = iceProcessingStateSyncRoot;
            synchronized (object) {
                while (IceProcessingState.RUNNING.equals((Object)this.iceAgent.getState())) {
                    try {
                        iceProcessingStateSyncRoot.wait();
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                    }
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.iceAgent.removeStateChangeListener(stateChangeListener);
            if (IceProcessingState.FAILED.equals((Object)this.iceAgent.getState())) {
                String msg = JabberActivator.getResources().getI18NString("service.protocol.ICE_FAILED");
                throw new OperationFailedException(msg, 1);
            }
        } else {
            delegate.wrapupConnectivityEstablishment();
        }
        if (this.cpeList != null) {
            for (ContentPacketExtension content : this.cpeList) {
                IceUdpTransportPacketExtension transport = content.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                if (transport == null) continue;
                for (CandidatePacketExtension candidate : transport.getCandidateList()) {
                    transport.removeCandidate(candidate);
                }
                List<CandidatePacketExtension> childExtensions = transport.getChildExtensionsOfType(CandidatePacketExtension.class);
                if (childExtensions != null && !childExtensions.isEmpty()) continue;
                transport.removeAttribute("ufrag");
                transport.removeAttribute("pwd");
            }
        }
    }

    @Override
    public void removeContent(String name) {
        IceMediaStream stream;
        RtpDescriptionPacketExtension rtpDescription;
        ContentPacketExtension content = this.removeContent(this.cpeList, name);
        if (content != null && (rtpDescription = content.getFirstChildOfType(RtpDescriptionPacketExtension.class)) != null && (stream = this.iceAgent.getStream(rtpDescription.getMedia())) != null) {
            this.iceAgent.removeStream(stream);
        }
    }

    @Override
    public synchronized void close() {
        if (this.iceAgent != null) {
            this.iceAgent.removeStateChangeListener((PropertyChangeListener)this);
            this.iceAgent.free();
        }
    }

    public String getICECandidateExtendedType(String streamName) {
        return TransportManager.getICECandidateExtendedType((Agent)this.iceAgent, (String)streamName);
    }

    public String getICEState() {
        return this.iceAgent.getState().toString();
    }

    public InetSocketAddress getICELocalHostAddress(String streamName) {
        LocalCandidate localCandidate;
        if (this.iceAgent != null && (localCandidate = this.iceAgent.getSelectedLocalCandidate(streamName)) != null) {
            return localCandidate.getHostAddress();
        }
        return null;
    }

    public InetSocketAddress getICERemoteHostAddress(String streamName) {
        RemoteCandidate remoteCandidate;
        if (this.iceAgent != null && (remoteCandidate = this.iceAgent.getSelectedRemoteCandidate(streamName)) != null) {
            return remoteCandidate.getHostAddress();
        }
        return null;
    }

    public InetSocketAddress getICELocalReflexiveAddress(String streamName) {
        LocalCandidate localCandidate;
        if (this.iceAgent != null && (localCandidate = this.iceAgent.getSelectedLocalCandidate(streamName)) != null) {
            return localCandidate.getReflexiveAddress();
        }
        return null;
    }

    public InetSocketAddress getICERemoteReflexiveAddress(String streamName) {
        RemoteCandidate remoteCandidate;
        if (this.iceAgent != null && (remoteCandidate = this.iceAgent.getSelectedRemoteCandidate(streamName)) != null) {
            return remoteCandidate.getReflexiveAddress();
        }
        return null;
    }

    public InetSocketAddress getICELocalRelayedAddress(String streamName) {
        LocalCandidate localCandidate;
        if (this.iceAgent != null && (localCandidate = this.iceAgent.getSelectedLocalCandidate(streamName)) != null) {
            return localCandidate.getRelayedAddress();
        }
        return null;
    }

    public InetSocketAddress getICERemoteRelayedAddress(String streamName) {
        RemoteCandidate remoteCandidate;
        if (this.iceAgent != null && (remoteCandidate = this.iceAgent.getSelectedRemoteCandidate(streamName)) != null) {
            return remoteCandidate.getRelayedAddress();
        }
        return null;
    }

    public long getTotalHarvestingTime() {
        return this.iceAgent == null ? 0L : this.iceAgent.getTotalHarvestingTime();
    }

    public long getHarvestingTime(String harvesterName) {
        return this.iceAgent == null ? 0L : this.iceAgent.getHarvestingTime(harvesterName);
    }

    public int getNbHarvesting() {
        return this.iceAgent == null ? 0 : this.iceAgent.getHarvestCount();
    }

    public int getNbHarvesting(String harvesterName) {
        return this.iceAgent == null ? 0 : this.iceAgent.getHarvestCount(harvesterName);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ((CallPeerMediaHandlerJabberImpl)((CallPeerJabberImpl)this.getCallPeer()).getMediaHandler()).firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }
}

