/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkUtil {
    private static Method isUp;
    private static Method supportsMulticast;
    private static final Pattern EXPRESSION_EXTRACTOR;

    private NetworkUtil() {
    }

    public static void main(String[] args) throws UnknownHostException, SocketException {
        System.out.println(NetworkUtil.dumpLocalNetworkInfo());
    }

    public static InetAddress getLocalAddress() throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getLocalHost();
        NetworkInterface nif = NetworkInterface.getByInetAddress(addr);
        if (addr.isLoopbackAddress() || addr instanceof Inet6Address || nif == null) {
            InetAddress lookedUpAddr = NetworkUtil.findLocalAddressViaNetworkInterface();
            addr = lookedUpAddr != null ? lookedUpAddr : InetAddress.getByName("127.0.0.1");
        }
        return addr;
    }

    public static InetAddress getLocalAddressWithMulticast() throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getLocalHost();
        NetworkInterface nif = NetworkInterface.getByInetAddress(addr);
        if (addr.isLoopbackAddress() || addr instanceof Inet6Address || !NetworkUtil.isMulticastSupported(nif)) {
            InetAddress lookedUpAddr = NetworkUtil.findLocalAddressViaNetworkInterface();
            if (lookedUpAddr != null) {
                return lookedUpAddr;
            }
            addr = InetAddress.getByName("127.0.0.1");
        }
        if (NetworkUtil.isMulticastSupported(addr)) {
            return addr;
        }
        throw new UnknownHostException("Cannot find address of local host which can be used for multicasting");
    }

    public static InetAddress findLocalAddressViaNetworkInterface() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface nif = networkInterfaces.nextElement();
            Enumeration<InetAddress> addrEnum = nif.getInetAddresses();
            while (addrEnum.hasMoreElements()) {
                InetAddress interfaceAddress = addrEnum.nextElement();
                if (!NetworkUtil.useInetAddress(nif, interfaceAddress)) continue;
                return interfaceAddress;
            }
        }
        return null;
    }

    public static boolean isMulticastSupported() throws SocketException {
        return NetworkUtil.getMulticastAddresses().size() != 0;
    }

    public static boolean isMulticastSupported(NetworkInterface pNif) {
        return pNif != null && NetworkUtil.checkMethod(pNif, isUp) != false && NetworkUtil.checkMethod(pNif, supportsMulticast) != false;
    }

    public static boolean isMulticastSupported(InetAddress pAddr) throws SocketException {
        return NetworkUtil.isMulticastSupported(NetworkInterface.getByInetAddress(pAddr));
    }

    public static List<InetAddress> getMulticastAddresses() throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>();
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            if (!NetworkUtil.checkMethod(nif, supportsMulticast).booleanValue() || !NetworkUtil.checkMethod(nif, isUp).booleanValue()) continue;
            Enumeration<InetAddress> addresses = nif.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (addr instanceof Inet6Address) continue;
                ret.add(addr);
            }
        }
        return ret;
    }

    public static String getAgentId(int objectId, String type) {
        String address;
        try {
            address = NetworkUtil.getLocalAddress().getHostAddress();
        }
        catch (IOException exp) {
            address = "local";
        }
        return address + "-" + NetworkUtil.getProcessId() + "-" + Integer.toHexString(objectId) + "-" + type;
    }

    public static String sanitizeLocalUrl(String pRequestURL) {
        try {
            URL url = new URL(pRequestURL);
            String host = url.getHost();
            InetAddress address = NetworkUtil.findLocalAddressListeningOnPort(host, url.getPort());
            return new URL(url.getProtocol(), address.getHostAddress(), url.getPort(), url.getFile()).toExternalForm();
        }
        catch (IOException e) {
            return pRequestURL;
        }
    }

    private static boolean useInetAddress(NetworkInterface networkInterface, InetAddress interfaceAddress) {
        return NetworkUtil.checkMethod(networkInterface, isUp) != false && NetworkUtil.checkMethod(networkInterface, supportsMulticast) != false && !(interfaceAddress instanceof Inet6Address) && !interfaceAddress.isLoopbackAddress();
    }

    private static Boolean checkMethod(NetworkInterface iface, Method toCheck) {
        if (toCheck != null) {
            try {
                return (Boolean)toCheck.invoke((Object)iface, (Object[])null);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
        }
        return true;
    }

    private static InetAddress findLocalAddressListeningOnPort(String pHost, int pPort) throws UnknownHostException, SocketException {
        InetAddress address = InetAddress.getByName(pHost);
        if (address.isLoopbackAddress()) {
            InetAddress localAddress = NetworkUtil.getLocalAddress();
            if (!localAddress.isLoopbackAddress() && NetworkUtil.isPortOpen(localAddress, pPort)) {
                return localAddress;
            }
            localAddress = NetworkUtil.getLocalAddressFromNetworkInterfacesListeningOnPort(pPort);
            if (localAddress != null) {
                return localAddress;
            }
        }
        return address;
    }

    private static InetAddress getLocalAddressFromNetworkInterfacesListeningOnPort(int pPort) {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface nif = networkInterfaces.nextElement();
                Enumeration<InetAddress> addrEnum = nif.getInetAddresses();
                while (addrEnum.hasMoreElements()) {
                    InetAddress interfaceAddress = addrEnum.nextElement();
                    if (interfaceAddress.isLoopbackAddress() || !NetworkUtil.checkMethod(nif, isUp).booleanValue() || !NetworkUtil.isPortOpen(interfaceAddress, pPort)) continue;
                    return interfaceAddress;
                }
            }
        }
        catch (SocketException e) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isPortOpen(InetAddress pAddress, int pPort) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.setReuseAddress(true);
            InetSocketAddress sa = new InetSocketAddress(pAddress, pPort);
            socket.connect(sa, 200);
            boolean bl = socket.isConnected();
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static String getProcessId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        return index < 0 ? jvmName : jvmName.substring(0, index);
    }

    public static String dumpLocalNetworkInfo() throws UnknownHostException, SocketException {
        StringBuffer buffer = new StringBuffer();
        InetAddress addr = InetAddress.getLocalHost();
        buffer.append("Localhost: " + NetworkUtil.getAddrInfo(addr) + "\n");
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        buffer.append("Network interfaces:\n");
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            buffer.append("  - " + NetworkUtil.getNetworkInterfaceInfo(nif) + "\n");
            Enumeration<InetAddress> addresses = nif.getInetAddresses();
            while (addresses.hasMoreElements()) {
                addr = addresses.nextElement();
                buffer.append("    " + NetworkUtil.getAddrInfo(addr) + "\n");
            }
        }
        return buffer.toString();
    }

    public static String replaceExpression(String pValue) {
        if (pValue == null) {
            return null;
        }
        Matcher matcher = EXPRESSION_EXTRACTOR.matcher(pValue);
        StringBuffer ret = new StringBuffer();
        try {
            while (matcher.find()) {
                String value;
                String var = matcher.group(1);
                if (var.equalsIgnoreCase("host")) {
                    value = NetworkUtil.getLocalAddress().getHostName();
                } else if (var.equalsIgnoreCase("ip")) {
                    value = NetworkUtil.getLocalAddress().getHostAddress();
                } else {
                    String key = NetworkUtil.extractKey(var, "env");
                    if (key != null) {
                        value = System.getenv(key);
                    } else {
                        key = NetworkUtil.extractKey(var, "prop");
                        if (key != null) {
                            value = System.getProperty(key);
                        } else {
                            throw new IllegalArgumentException("Unknown expression " + var + " in " + pValue);
                        }
                    }
                }
                matcher.appendReplacement(ret, value != null ? value.trim() : null);
            }
            matcher.appendTail(ret);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot lookup host" + e, e);
        }
        return ret.toString();
    }

    private static String extractKey(String pVar, String pPrefix) {
        if (pVar.toLowerCase().startsWith(pPrefix + ":")) {
            String ret = pVar.substring(pPrefix.length() + 1);
            if (ret.length() == 0) {
                throw new IllegalArgumentException("Expression with " + pPrefix + ": must not contain spaces");
            }
            return ret;
        }
        return null;
    }

    private static String getAddrInfo(InetAddress pAddr) throws SocketException {
        String ret = pAddr.getHostName() != null ? pAddr.getHostName() + " (" + pAddr.getHostAddress() + ")" : pAddr.getHostAddress();
        ret = ret + " [site-local: " + pAddr.isSiteLocalAddress() + ", link-local: " + pAddr.isLinkLocalAddress() + ", lb: " + pAddr.isLoopbackAddress() + "]";
        NetworkInterface nif = NetworkInterface.getByInetAddress(pAddr);
        ret = ret + " -- nif: " + NetworkUtil.getNetworkInterfaceInfo(nif);
        return ret;
    }

    private static String getNetworkInterfaceInfo(NetworkInterface pNif) throws SocketException {
        if (pNif == null) {
            return "[null]";
        }
        return pNif.getDisplayName() + " [up: " + pNif.isUp() + ", mc: " + pNif.supportsMulticast() + ", lb: " + pNif.isLoopback() + ", hw: " + NetworkUtil.formatHwAddress(pNif.getHardwareAddress()) + "]";
    }

    private static String formatHwAddress(byte[] pHardwareAddress) {
        if (pHardwareAddress == null) {
            return "[none]";
        }
        StringBuilder sb = new StringBuilder(18);
        for (byte b : pHardwareAddress) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    static {
        try {
            isUp = NetworkInterface.class.getMethod("isUp", null);
            supportsMulticast = NetworkInterface.class.getMethod("supportsMulticast", null);
        }
        catch (NoSuchMethodException e) {
            isUp = null;
            supportsMulticast = null;
        }
        EXPRESSION_EXTRACTOR = Pattern.compile("\\$\\{?\\s*([\\w:-_.]+)\\s*}?");
    }
}

