/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.EnumEvent;
import com.voxeo.utils.Event;
import com.voxeo.utils.EventListener;
import com.voxeo.utils.FatalExceptionHandler;
import com.voxeo.utils.IEvent;
import com.voxeo.utils.IEventDispatcher;
import com.voxeo.utils.SynchronousExecutor;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDispatcher
implements IEventDispatcher {
    private Loggerf log = Loggerf.getLogger(EventDispatcher.class);
    private ConcurrentHashMap<Class<?>, List<Object>> clazzListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<Object, List<Object>> enumListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<Object, List<Object>> lifecycleObjectMap = new ConcurrentHashMap();
    private List<FatalExceptionHandler> exceptionHandlers = new CopyOnWriteArrayList<FatalExceptionHandler>();
    private Executor executor = SynchronousExecutor.get();
    private Lock lifecycleLock = new ReentrantLock();

    public EventDispatcher() {
    }

    public EventDispatcher(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void addListener(Class<?> eventClazz, EventListener<?> listener) {
        List<Object> list = this.clazzListeners.get(eventClazz);
        if (list == null) {
            list = new CopyOnWriteArrayList<Object>();
            List<Object> existing = this.clazzListeners.putIfAbsent(eventClazz, list);
            if (existing != null) {
                existing.add(listener);
            } else {
                list.add(listener);
            }
        } else {
            list.add(listener);
        }
    }

    @Override
    public <E extends Enum<E>> void addListener(E type, EventListener<? extends EnumEvent<?, E>> listener) {
        List<Object> list = this.enumListeners.get(type);
        if (list == null) {
            list = new CopyOnWriteArrayList<Object>();
            List<Object> existing = this.enumListeners.putIfAbsent(type, list);
            if (existing != null) {
                existing.add(listener);
            } else {
                list.add(listener);
            }
        } else {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object lifecycleObject, Class<?> eventClazz, EventListener<?> listener) {
        this.lifecycleLock.lock();
        try {
            this.addToLifecycleMap(lifecycleObject, listener);
            this.addListener((Enum)((Object)eventClazz), (EventListener)listener);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Enum<E>> void addListener(Object lifecycleObject, E type, EventListener<? extends EnumEvent<?, E>> listener) {
        this.lifecycleLock.lock();
        try {
            this.addToLifecycleMap(lifecycleObject, listener);
            this.addListener(type, listener);
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    private void addToLifecycleMap(Object lifecycleObject, EventListener<?> listener) {
        List<Object> list = this.lifecycleObjectMap.get(lifecycleObject);
        if (list == null) {
            list = new CopyOnWriteArrayList<Object>();
            List<Object> existing = this.lifecycleObjectMap.putIfAbsent(lifecycleObject, list);
            if (existing != null) {
                existing.add(listener);
            } else {
                list.add(listener);
            }
        } else {
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListenersForLifecycleObject(Object lifecycleObject) {
        this.lifecycleLock.lock();
        try {
            List<Object> list;
            if (this.lifecycleObjectMap != null && (list = this.lifecycleObjectMap.remove(lifecycleObject)) != null) {
                for (Object o : list) {
                    this.removeListener((EventListener)o);
                }
            }
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void removeListener(EventListener<?> listener) {
        for (List<Object> list : this.clazzListeners.values()) {
            list.remove(listener);
        }
        for (List<Object> list : this.enumListeners.values()) {
            list.remove(listener);
        }
    }

    @Override
    public <S, T extends IEvent<S>> Future<T> fire(T event) {
        return this.fire(event, true);
    }

    @Override
    public <S, T extends IEvent<S>> Future<T> fire(final T event, final boolean narrowType) {
        FutureTask<T> task = new FutureTask<T>(new Runnable(){

            @Override
            public void run() {
                EventDispatcher.this.log.trace("Firing event %s", event);
                Class<?> clazz = event.getClass();
                do {
                    List list = (List)EventDispatcher.this.clazzListeners.get(clazz);
                    this.fireEvents(event, list);
                    clazz = clazz.getSuperclass();
                } while (narrowType && !clazz.equals(Object.class));
                if (event instanceof EnumEvent) {
                    EnumEvent enumEvent = (EnumEvent)event;
                    List list = (List)EventDispatcher.this.enumListeners.get(enumEvent.type);
                    this.fireEvents(event, list);
                }
            }

            private void fireEvents(T event2, List<Object> list) {
                if (list != null) {
                    for (Object listener : list) {
                        try {
                            ((EventListener)listener).onEvent(event2);
                        }
                        catch (RuntimeException e) {
                            if (!EventDispatcher.this.exceptionHandlers.isEmpty()) {
                                for (FatalExceptionHandler handler : EventDispatcher.this.exceptionHandlers) {
                                    try {
                                        handler.handle(e, (EventListener)listener, (IEvent<?>)event2);
                                    }
                                    catch (Exception exceptionHandlerException) {
                                        EventDispatcher.this.log.error("Go figure, Exception while while notifying FatalExceptionHandler", e);
                                    }
                                }
                            } else {
                                EventDispatcher.this.log.error("Unhandled Exception in EventDispatcher [listener=%s, event=%s]", listener, event2, e);
                            }
                            throw e;
                        }
                    }
                }
            }
        }, event);
        this.executor.execute(task);
        return task;
    }

    @Override
    public void addFatalExceptionHandler(FatalExceptionHandler handler) {
        this.exceptionHandlers.add(handler);
    }

    @Override
    public void removeFatalExceptionHandler(FatalExceptionHandler handler) {
        this.exceptionHandlers.remove(handler);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public static void main(String[] args) {
        EventDispatcher e = new EventDispatcher();
        e.addListener(null, new EventListener<Event<?>>(){

            @Override
            public void onEvent(Event<?> event) {
            }
        });
    }
}

