/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class UTFUtil {
    private static final int STRING_CHUNK_SIZE = 16384;

    public static void writeUTF(DataOutput out, String str) throws IOException {
        boolean isNull = str == null;
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        int length = str.length();
        out.writeInt(length);
        int chunkSize = length / 16384 + 1;
        for (int i = 0; i < chunkSize; ++i) {
            int beginIndex = Math.max(0, i * 16384 - 1);
            int endIndex = Math.min((i + 1) * 16384 - 1, length);
            UTFUtil.writeShortUTF(out, str.substring(beginIndex, endIndex));
        }
    }

    private static void writeShortUTF(DataOutput out, String str) throws IOException {
        char c;
        int i;
        int stringLen = str.length();
        int utfLength = 0;
        int count = 0;
        for (i = 0; i < stringLen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utfLength;
                continue;
            }
            if (c > '\u07ff') {
                utfLength += 3;
                continue;
            }
            utfLength += 2;
        }
        if (utfLength > 65535) {
            throw new UTFDataFormatException("encoded string too long:" + utfLength + " bytes");
        }
        out.writeShort(utfLength);
        byte[] byteArray = new byte[utfLength];
        for (i = 0; i < stringLen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            byteArray[count++] = (byte)c;
        }
        while (i < stringLen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byteArray[count++] = (byte)c;
            } else if (c > '\u07ff') {
                byteArray[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                byteArray[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                byteArray[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                byteArray[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byteArray[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        out.write(byteArray, 0, utfLength);
    }

    public static String readUTF(DataInput in) throws IOException {
        boolean isNull = in.readBoolean();
        if (isNull) {
            return null;
        }
        int length = in.readInt();
        StringBuilder result = new StringBuilder(length);
        for (int chunkSize = length / 16384 + 1; chunkSize > 0; --chunkSize) {
            result.append(UTFUtil.readShortUTF(in));
        }
        return result.toString();
    }

    private static String readShortUTF(DataInput in) throws IOException {
        int c;
        int count;
        int utflen = in.readShort();
        byte[] bytearr = null;
        char[] chararr = null;
        bytearr = new byte[utflen];
        chararr = new char[utflen];
        int chararr_count = 0;
        in.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararr_count++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararr_count++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararr_count);
    }
}

