/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.JoinRequest;
import com.hazelcast.cluster.Joiner;
import com.hazelcast.cluster.MulticastJoiner;
import com.hazelcast.cluster.MulticastListener;
import com.hazelcast.core.Member;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.util.AddressUtil;
import java.util.Set;

public class NodeMulticastListener
implements MulticastListener {
    final Node node;
    final Set<String> trustedInterfaces;
    final ILogger logger;

    public NodeMulticastListener(Node node) {
        this.node = node;
        this.trustedInterfaces = node.getConfig().getNetworkConfig().getJoin().getMulticastConfig().getTrustedInterfaces();
        this.logger = node.getLogger("NodeMulticastListener");
    }

    @Override
    public void onMessage(Object msg) {
        if (msg != null && msg instanceof JoinMessage) {
            JoinMessage joinMessage = (JoinMessage)msg;
            if (this.node.getThisAddress() != null && !this.node.getThisAddress().equals(joinMessage.getAddress())) {
                boolean validJoinRequest;
                try {
                    validJoinRequest = this.node.getClusterService().validateJoinMessage(joinMessage);
                }
                catch (Exception e) {
                    validJoinRequest = false;
                }
                if (validJoinRequest) {
                    Joiner joiner;
                    if (this.node.isActive() && this.node.joined()) {
                        if (joinMessage instanceof JoinRequest) {
                            if (this.node.isMaster()) {
                                JoinRequest request = (JoinRequest)joinMessage;
                                JoinMessage response = new JoinMessage(request.getPacketVersion(), request.getBuildNumber(), this.node.getThisAddress(), request.getUuid(), request.getConfigCheck(), this.node.getClusterService().getSize());
                                this.node.multicastService.send(response);
                            } else if (this.isMasterNode(joinMessage.getAddress()) && !this.checkMasterUuid(joinMessage.getUuid())) {
                                this.logger.warning("New join request has been received from current master. Removing " + this.node.getMasterAddress());
                                this.node.getClusterService().removeAddress(this.node.getMasterAddress());
                            }
                        }
                    } else if (!this.node.joined() && !(joinMessage instanceof JoinRequest)) {
                        if (this.node.getMasterAddress() == null) {
                            String masterHost = joinMessage.getAddress().getHost();
                            if (this.trustedInterfaces.isEmpty() || AddressUtil.matchAnyInterface(masterHost, this.trustedInterfaces)) {
                                this.node.setMasterAddress(new Address(joinMessage.getAddress()));
                            } else if (this.logger.isFinestEnabled()) {
                                this.logger.finest(String.format("JoinMessage from %s is dropped because its sender is not a trusted interface", masterHost));
                            }
                        }
                    } else if (joinMessage instanceof JoinRequest && (joiner = this.node.getJoiner()) instanceof MulticastJoiner) {
                        MulticastJoiner multicastJoiner = (MulticastJoiner)joiner;
                        multicastJoiner.onReceivedJoinRequest((JoinRequest)joinMessage);
                    }
                }
            }
        }
    }

    private boolean isMasterNode(Address address) {
        return address.equals(this.node.getMasterAddress());
    }

    private boolean checkMasterUuid(String uuid) {
        Member masterMember = this.getMasterMember((Set<Member>)this.node.getClusterService().getMembers());
        return masterMember == null || masterMember.getUuid().equals(uuid);
    }

    private Member getMasterMember(Set<Member> members) {
        if (members == null || members.isEmpty()) {
            return null;
        }
        return members.iterator().next();
    }
}

