/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordQualityMeter {
    public static final int TOTAL_POINTS = 42;

    public int assessPassword(String pass) {
        int score = 0;
        if (pass == null || pass.length() == 0) {
            return score;
        }
        score += this.assessLength(pass);
        score += this.assessLetters(pass);
        score += this.assessNumbers(pass);
        return score += this.assessSpecials(pass);
    }

    private int assessLength(String pass) {
        int len = pass.length();
        if (len < 5) {
            return 3;
        }
        if (len >= 5 && len < 8) {
            return 6;
        }
        if (len >= 8 && len < 16) {
            return 12;
        }
        return 18;
    }

    private int assessLetters(String pass) {
        boolean lower = this.matches(pass, "[a-z]+");
        boolean upper = this.matches(pass, "[A-Z]+");
        if (lower && upper) {
            return 7;
        }
        if (lower || upper) {
            return 5;
        }
        return 0;
    }

    private int assessNumbers(String pass) {
        int found = this.countMatches(pass, "\\d");
        if (found < 1) {
            return 0;
        }
        if (found >= 1 && found < 3) {
            return 5;
        }
        return 7;
    }

    private int assessSpecials(String pass) {
        int found = this.countMatches(pass, "[^\\w\\s]");
        if (found < 1) {
            return 0;
        }
        if (found <= 1 && found < 2) {
            return 5;
        }
        return 10;
    }

    private int countMatches(String str, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(str);
        int found = 0;
        while (matcher.find()) {
            ++found;
        }
        return found;
    }

    private boolean matches(String str, String pattern) {
        return Pattern.compile(pattern).matcher(str).find();
    }
}

