/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.client.BaseTransactionRequest;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import java.io.IOException;
import java.security.Permission;

public class CreateTransactionRequest
extends BaseTransactionRequest
implements SecureRequest {
    private TransactionOptions options;

    public CreateTransactionRequest() {
    }

    public CreateTransactionRequest(TransactionOptions options) {
        this.options = options;
    }

    @Override
    public Object innerCall() throws Exception {
        ClientEngineImpl clientEngine = (ClientEngineImpl)this.getService();
        ClientEndpoint endpoint = this.getEndpoint();
        TransactionManagerServiceImpl transactionManager = (TransactionManagerServiceImpl)clientEngine.getTransactionManagerService();
        TransactionContext context = transactionManager.newClientTransactionContext(this.options, endpoint.getUuid());
        context.beginTransaction();
        endpoint.setTransactionContext(context);
        return context.getTxnId();
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.options.writeData(out);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.options = new TransactionOptions();
        this.options.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

