/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.getters.FieldGetter;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.MethodGetter;
import com.hazelcast.query.impl.getters.NullGetter;
import com.hazelcast.query.impl.getters.ThisGetter;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ReflectionHelper {
    static final ClassLoader THIS_CL = ReflectionHelper.class.getClassLoader();
    private static final int INITIAL_CAPACITY = 3;
    private static final ConcurrentMap<Class, ConcurrentMap<String, Getter>> GETTER_CACHE = new ConcurrentHashMap<Class, ConcurrentMap<String, Getter>>(1000);
    private static final ConstructorFunction<Class, ConcurrentMap<String, Getter>> GETTER_CACHE_CONSTRUCTOR = new ConstructorFunction<Class, ConcurrentMap<String, Getter>>(){

        @Override
        public ConcurrentMap<String, Getter> createNew(Class arg) {
            return new ConcurrentHashMap<String, Getter>();
        }
    };

    private ReflectionHelper() {
    }

    public static AttributeType getAttributeType(Class klass) {
        if (klass == null) {
            return null;
        }
        if (klass == String.class) {
            return AttributeType.STRING;
        }
        if (klass == Integer.TYPE || klass == Integer.class) {
            return AttributeType.INTEGER;
        }
        if (klass == Short.TYPE || klass == Short.class) {
            return AttributeType.SHORT;
        }
        if (klass == Long.TYPE || klass == Long.class) {
            return AttributeType.LONG;
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            return AttributeType.BOOLEAN;
        }
        if (klass == Double.TYPE || klass == Double.class) {
            return AttributeType.DOUBLE;
        }
        if (klass == BigDecimal.class) {
            return AttributeType.BIG_DECIMAL;
        }
        if (klass == BigInteger.class) {
            return AttributeType.BIG_INTEGER;
        }
        if (klass == Float.TYPE || klass == Float.class) {
            return AttributeType.FLOAT;
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            return AttributeType.BYTE;
        }
        if (klass == Character.TYPE || klass == Character.class) {
            return AttributeType.CHAR;
        }
        if (klass == Timestamp.class) {
            return AttributeType.SQL_TIMESTAMP;
        }
        if (klass == Date.class) {
            return AttributeType.SQL_DATE;
        }
        if (klass == java.util.Date.class) {
            return AttributeType.DATE;
        }
        if (klass.isEnum()) {
            return AttributeType.ENUM;
        }
        if (klass == UUID.class) {
            return AttributeType.UUID;
        }
        return null;
    }

    private static Getter get(Class clazz, String attribute) {
        ConcurrentMap cache = (ConcurrentMap)GETTER_CACHE.get(clazz);
        if (cache == null) {
            return null;
        }
        return (Getter)cache.get(attribute);
    }

    private static Getter set(Class clazz, String attribute, Getter getter) {
        ConcurrentMap<String, Getter> cache = ConcurrencyUtil.getOrPutIfAbsent(GETTER_CACHE, clazz, GETTER_CACHE_CONSTRUCTOR);
        Getter foundGetter = cache.putIfAbsent(attribute, getter);
        return foundGetter == null ? getter : foundGetter;
    }

    public static void reset() {
        GETTER_CACHE.clear();
    }

    public static AttributeType getAttributeType(Object value, String attribute) {
        return ReflectionHelper.getAttributeType(ReflectionHelper.createGetter(value, attribute).getReturnType());
    }

    private static Getter createGetter(Object obj, String attribute) {
        if (obj == null || obj == IndexImpl.NULL) {
            return NullGetter.NULL_GETTER;
        }
        Class<?> targetClazz = obj.getClass();
        Class<?> clazz = targetClazz;
        Getter getter = ReflectionHelper.get(clazz, attribute);
        if (getter != null) {
            return getter;
        }
        try {
            ThisGetter parent = null;
            ArrayList<String> possibleMethodNames = new ArrayList<String>(3);
            for (String name : attribute.split("\\.")) {
                Getter localGetter = null;
                possibleMethodNames.clear();
                possibleMethodNames.add(name);
                String camelName = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                possibleMethodNames.add("get" + camelName);
                possibleMethodNames.add("is" + camelName);
                if (name.equals("this")) {
                    localGetter = new ThisGetter(parent, obj);
                } else {
                    for (String methodName : possibleMethodNames) {
                        try {
                            Method method = clazz.getMethod(methodName, new Class[0]);
                            method.setAccessible(true);
                            localGetter = new MethodGetter(parent, method);
                            clazz = method.getReturnType();
                            break;
                        }
                        catch (NoSuchMethodException ignored) {
                            EmptyStatement.ignore(ignored);
                        }
                    }
                    if (localGetter == null) {
                        try {
                            Field field = clazz.getField(name);
                            localGetter = new FieldGetter(parent, field);
                            clazz = field.getType();
                        }
                        catch (NoSuchFieldException ignored) {
                            EmptyStatement.ignore(ignored);
                        }
                    }
                    if (localGetter == null) {
                        Class<?> c = clazz;
                        while (!Object.class.equals(c)) {
                            try {
                                Field field = c.getDeclaredField(name);
                                field.setAccessible(true);
                                localGetter = new FieldGetter(parent, field);
                                clazz = field.getType();
                                break;
                            }
                            catch (NoSuchFieldException ignored) {
                                c = c.getSuperclass();
                            }
                        }
                    }
                }
                if (localGetter == null) {
                    throw new IllegalArgumentException("There is no suitable accessor for '" + name + "' on class '" + clazz + "'");
                }
                parent = localGetter;
            }
            getter = parent;
            if (getter.isCacheable()) {
                getter = ReflectionHelper.set(targetClazz, attribute, getter);
            }
            return getter;
        }
        catch (Throwable e) {
            throw new QueryException(e);
        }
    }

    public static Comparable extractValue(Object object, String attributeName) throws Exception {
        return (Comparable)ReflectionHelper.createGetter(object, attributeName).getValue(object);
    }

    public static <T> T invokeMethod(Object object, String methodName) throws RuntimeException {
        try {
            Method method = object.getClass().getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

