/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument doc) {
        super(doc);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont font) {
        if (font instanceof RtfParagraphStyle) {
            font = new RtfFont(this.document, font);
        }
        int fontIndex = -1;
        int i = 0;
        while (i < this.fontList.size()) {
            if (this.fontList.get(i).equals(font)) {
                fontIndex = i;
            }
            ++i;
        }
        if (fontIndex == -1) {
            fontIndex = this.fontList.size();
            this.fontList.add(font);
        }
        return fontIndex;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            result.write(DEFAULT_FONT);
            result.write(this.intToByteArray(0));
            result.write(OPEN_GROUP);
            result.write(FONT_TABLE);
            int i = 0;
            while (i < this.fontList.size()) {
                result.write(OPEN_GROUP);
                result.write(FONT_NUMBER);
                result.write(this.intToByteArray(i));
                result.write(((RtfFont)this.fontList.get(i)).writeDefinition());
                result.write(COMMA_DELIMITER);
                result.write(CLOSE_GROUP);
                ++i;
            }
            result.write(CLOSE_GROUP);
            result.write(10);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return result.toByteArray();
    }
}

