/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.spring.properties;

import com.voxeo.logging.Loggerf;
import com.voxeo.spring.properties.DefaultPropertyPlaceholderConfigurer;
import com.voxeo.spring.properties.PropertiesReloadedEvent;
import com.voxeo.spring.properties.ReconfigurationAware;
import com.voxeo.spring.properties.ReloadableProperties;
import com.voxeo.spring.properties.ReloadablePropertiesListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ObjectUtils;

public class ReloadingPropertyPlaceholderConfigurer
extends DefaultPropertyPlaceholderConfigurer
implements InitializingBean,
DisposableBean,
ReloadablePropertiesListener,
ApplicationContextAware {
    private static final Loggerf log = Loggerf.getLogger(ReloadingPropertyPlaceholderConfigurer.class);
    public static final String DEFAULT_RELOADING_PLACEHOLDER_PREFIX = "#{";
    public static final String DEFAULT_RELOADING_PLACEHOLDER_SUFFIX = "}";
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String beanName;
    private BeanFactory beanFactory;
    private Properties[] propertiesArray;
    private ApplicationContext applicationContext;
    private String reloadingPlaceholderPrefix = "#{";
    private String reloadingPlaceholderSuffix = "}";
    private Properties lastMergedProperties;
    private Map<DynamicProperty, DynamicProperty> dynamicProperties = new HashMap<DynamicProperty, DynamicProperty>();
    private Map<String, List<DynamicProperty>> placeholderToDynamics = new HashMap<String, List<DynamicProperty>>();
    private String currentBeanName;
    private String currentPropertyName;

    public void setProperties(Properties properties) {
        this.setPropertiesArray(new Properties[]{properties});
    }

    public void setPropertiesArray(Properties[] propertiesArray) {
        this.propertiesArray = propertiesArray;
        super.setPropertiesArray(propertiesArray);
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
        super.setPlaceholderPrefix(placeholderPrefix);
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
        super.setPlaceholderSuffix(this.placeholderPrefix);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
        super.setBeanName(beanName);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setReloadingPlaceholderPrefix(String reloadingPlaceholderPrefix) {
        this.reloadingPlaceholderPrefix = reloadingPlaceholderPrefix;
    }

    public void setReloadingPlaceholderSuffix(String reloadingPlaceholderSuffix) {
        this.reloadingPlaceholderSuffix = reloadingPlaceholderSuffix;
    }

    protected String parseStringValue(String strVal, Properties props, Set visitedPlaceholders) throws BeanDefinitionStoreException {
        DynamicProperty dynamic = null;
        StringBuffer buf = new StringBuffer(strVal);
        int startIndex = strVal.indexOf(this.reloadingPlaceholderPrefix);
        while (startIndex != -1) {
            int endIndex = buf.toString().indexOf(this.reloadingPlaceholderSuffix, startIndex + this.reloadingPlaceholderPrefix.length());
            if (endIndex != -1) {
                if (this.currentBeanName != null && this.currentPropertyName != null) {
                    String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                    placeholder = this.getPlaceholder(placeholder);
                    if (dynamic == null) {
                        dynamic = this.getDynamic(this.currentBeanName, this.currentPropertyName, strVal);
                    }
                    log.info("Registering reloadable property [bean=%s, property=%s, placeholder=%s]", this.beanName, this.currentPropertyName, placeholder);
                    this.addDependency(dynamic, placeholder);
                } else {
                    log.warn("dynamic property outside bean property value - ignored: " + strVal, new Object[0]);
                }
                buf.replace(endIndex, endIndex + this.reloadingPlaceholderSuffix.length(), this.placeholderSuffix);
                buf.replace(startIndex, startIndex + this.reloadingPlaceholderPrefix.length(), this.placeholderPrefix);
                startIndex = endIndex - this.reloadingPlaceholderPrefix.length() + this.placeholderPrefix.length() + this.placeholderSuffix.length();
                startIndex = strVal.indexOf(this.reloadingPlaceholderPrefix, startIndex);
                continue;
            }
            startIndex = -1;
        }
        return super.parseStringValue(buf.toString(), props, visitedPlaceholders);
    }

    private String parsePlaceholder(String placeholder) {
        StringBuffer buf = new StringBuffer(placeholder);
        int startIndex = placeholder.indexOf(this.reloadingPlaceholderPrefix);
        int endIndex = placeholder.indexOf(this.reloadingPlaceholderSuffix, startIndex + this.reloadingPlaceholderPrefix.length());
        return buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
    }

    private DynamicProperty getDynamic(String _currentBeanName, String _currentPropertyName, String orgStrVal) {
        DynamicProperty dynamic = new DynamicProperty(_currentBeanName, _currentPropertyName, orgStrVal);
        DynamicProperty found = this.dynamicProperties.get(dynamic);
        if (found != null) {
            return found;
        }
        this.dynamicProperties.put(dynamic, dynamic);
        return dynamic;
    }

    protected Properties mergeProperties() throws IOException {
        Properties properties;
        this.lastMergedProperties = properties = super.mergeProperties();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertiesReloaded(PropertiesReloadedEvent event) {
        Properties oldProperties = this.lastMergedProperties;
        try {
            Object bean;
            Properties newProperties = this.mergeProperties();
            Set<String> placeholders = this.placeholderToDynamics.keySet();
            HashSet<DynamicProperty> allDynamics = new HashSet<DynamicProperty>();
            for (String placeholder : placeholders) {
                String newValue = newProperties.getProperty(placeholder);
                String oldValue = oldProperties.getProperty(placeholder);
                if ((newValue == null || newValue.equals(oldValue)) && (newValue != null || oldValue == null)) continue;
                log.info("Property changed detected: %s", placeholder + (newValue != null ? "=" + newValue : " removed"));
                List<DynamicProperty> affectedDynamics = this.placeholderToDynamics.get(placeholder);
                allDynamics.addAll(affectedDynamics);
            }
            HashMap<String, ArrayList<DynamicProperty>> dynamicsByBeanName = new HashMap<String, ArrayList<DynamicProperty>>();
            HashMap beanByBeanName = new HashMap();
            for (DynamicProperty dynamic : allDynamics) {
                String dynamicBeanName = dynamic.getBeanName();
                ArrayList<DynamicProperty> l = (ArrayList<DynamicProperty>)dynamicsByBeanName.get(dynamicBeanName);
                if (l == null) {
                    l = new ArrayList<DynamicProperty>();
                    dynamicsByBeanName.put(dynamicBeanName, l);
                    bean = null;
                    try {
                        String factoryBeanName = "&" + dynamicBeanName;
                        bean = this.applicationContext.containsBean(factoryBeanName) ? this.applicationContext.getBean(factoryBeanName) : this.applicationContext.getBean(dynamicBeanName);
                        beanByBeanName.put(dynamicBeanName, bean);
                    }
                    catch (BeansException e) {
                        log.error("Error obtaining bean %s", new Object[]{dynamicBeanName, e});
                    }
                    try {
                        if (bean instanceof ReconfigurationAware) {
                            ((ReconfigurationAware)bean).beforeReconfiguration();
                        }
                    }
                    catch (Exception e) {
                        log.error("Error calling beforeReconfiguration on %s", dynamicBeanName, e);
                    }
                }
                l.add(dynamic);
            }
            HashMap changes = new HashMap(allDynamics.size());
            Set beanNames = dynamicsByBeanName.keySet();
            for (String dynamicBeanName : beanNames) {
                bean = beanByBeanName.get(dynamicBeanName);
                if (bean == null) continue;
                BeanWrapperImpl beanWrapper = new BeanWrapperImpl(bean);
                List dynamics = (List)dynamicsByBeanName.get(dynamicBeanName);
                HashMap<String, String> beanChanges = new HashMap<String, String>(dynamics.size());
                changes.put(dynamicBeanName, beanChanges);
                for (DynamicProperty dynamic : dynamics) {
                    String newValue;
                    String propertyName = dynamic.getPropertyName();
                    String unparsedValue = dynamic.getUnparsedValue();
                    this.removeDynamic(dynamic);
                    this.currentBeanName = dynamicBeanName;
                    this.currentPropertyName = propertyName;
                    try {
                        newValue = this.parseStringValue(unparsedValue, newProperties, new HashSet());
                    }
                    finally {
                        this.currentBeanName = null;
                        this.currentPropertyName = null;
                    }
                    log.info("Updating property %s.%s to %s", dynamicBeanName, propertyName, newValue);
                    String parsedPlaceholder = this.parsePlaceholder(dynamic.getUnparsedValue());
                    beanChanges.put(propertyName, oldProperties.getProperty(parsedPlaceholder));
                    try {
                        beanWrapper.setPropertyValue(propertyName, (Object)newValue);
                    }
                    catch (BeansException e) {
                        log.error("Error setting property %s.%s to %s", new Object[]{dynamicBeanName, propertyName, newValue, e});
                    }
                }
            }
            for (String dynamicBeanName : beanNames) {
                bean = beanByBeanName.get(dynamicBeanName);
                try {
                    if (!(bean instanceof ReconfigurationAware)) continue;
                    ((ReconfigurationAware)bean).afterReconfiguration((Map)changes.get(dynamicBeanName));
                }
                catch (Exception e) {
                    log.error("Error calling afterReconfiguration on %s", dynamicBeanName, e);
                }
            }
        }
        catch (IOException e) {
            log.error("Error trying to reload properties: %s", e.getMessage(), e);
        }
    }

    private void addDependency(DynamicProperty dynamic, String placeholder) {
        List<DynamicProperty> l = this.placeholderToDynamics.get(placeholder);
        if (l == null) {
            l = new ArrayList<DynamicProperty>();
            this.placeholderToDynamics.put(placeholder, l);
        }
        if (!l.contains(dynamic)) {
            l.add(dynamic);
        }
        dynamic.addPlaceholder(placeholder);
    }

    private void removeDynamic(DynamicProperty dynamic) {
        List<String> placeholders = dynamic.placeholders;
        for (String placeholder : placeholders) {
            List<DynamicProperty> l = this.placeholderToDynamics.get(placeholder);
            l.remove(dynamic);
        }
        dynamic.placeholders.clear();
        this.dynamicProperties.remove(dynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        PlaceholderResolvingBeanDefinitionVisitor visitor = new PlaceholderResolvingBeanDefinitionVisitor(props);
        String[] beanNames = beanFactoryToProcess.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            if (beanNames[i].equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            this.currentBeanName = beanNames[i];
            try {
                BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanNames[i]);
                try {
                    visitor.visitBeanDefinition(bd);
                    continue;
                }
                catch (BeanDefinitionStoreException ex) {
                    throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
                }
            }
            finally {
                this.currentBeanName = null;
            }
        }
    }

    public void afterPropertiesSet() {
        for (Properties properties : this.propertiesArray) {
            if (!(properties instanceof ReloadableProperties)) continue;
            ((ReloadableProperties)((Object)properties)).addReloadablePropertiesListener(this);
        }
    }

    public void destroy() throws Exception {
        for (Properties properties : this.propertiesArray) {
            if (!(properties instanceof ReloadableProperties)) continue;
            ((ReloadableProperties)((Object)properties)).removeReloadablePropertiesListener(this);
        }
    }

    private class PlaceholderResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private final Properties props;

        public PlaceholderResolvingBeanDefinitionVisitor(Properties props) {
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void visitPropertyValues(MutablePropertyValues pvs) {
            PropertyValue[] pvArray;
            for (PropertyValue pv : pvArray = pvs.getPropertyValues()) {
                ReloadingPropertyPlaceholderConfigurer.this.currentPropertyName = pv.getName();
                try {
                    Object newVal = this.resolveValue(pv.getValue());
                    if (ObjectUtils.nullSafeEquals((Object)newVal, (Object)pv.getValue())) continue;
                    pvs.addPropertyValue(pv.getName(), newVal);
                }
                finally {
                    ReloadingPropertyPlaceholderConfigurer.this.currentPropertyName = null;
                }
            }
        }

        protected String resolveStringValue(String strVal) throws BeansException {
            return ReloadingPropertyPlaceholderConfigurer.this.parseStringValue(strVal, this.props, new HashSet());
        }
    }

    static class DynamicProperty {
        final String beanName;
        final String propertyName;
        final String unparsedValue;
        List<String> placeholders = new ArrayList<String>();

        public DynamicProperty(String beanName, String propertyName, String unparsedValue) {
            this.beanName = beanName;
            this.propertyName = propertyName;
            this.unparsedValue = unparsedValue;
        }

        public void addPlaceholder(String placeholder) {
            this.placeholders.add(placeholder);
        }

        public String getUnparsedValue() {
            return this.unparsedValue;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicProperty that = (DynamicProperty)o;
            if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
                return false;
            }
            return !(this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null);
        }

        public int hashCode() {
            int result = this.beanName != null ? this.beanName.hashCode() : 0;
            result = 29 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
            return result;
        }
    }
}

