/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.io.IOException;
import java.util.logging.Logger;
import javax.media.DataSink;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.NotRealizedError;
import javax.media.Processor;
import javax.media.control.TrackControl;
import javax.media.protocol.DataSource;
import net.sf.fmj.ejmf.toolkit.util.StateWaiter;
import net.sf.fmj.ui.wizards.ProcessorWizardConfig;
import net.sf.fmj.ui.wizards.TrackConfig;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.LoggerSingleton;

public class ProcessorWizardResult {
    private static final Logger logger = LoggerSingleton.logger;
    public Processor processor;
    private StateWaiter stateWaiter;
    private DataSource destDataSource;
    private DataSink destDataSink;

    public void step1_createProcessorAndSetUrl(ProcessorWizardConfig processorWizardConfig) throws WizardStepException {
        String string = processorWizardConfig.url;
        if (string == null || string.equals("")) {
            throw new WizardStepException("Source URL may not be blank");
        }
        logger.fine("Creating processor");
        try {
            this.processor = Manager.createProcessor(new MediaLocator(string));
        }
        catch (IOException iOException) {
            throw new WizardStepException(iOException);
        }
        catch (NoProcessorException noProcessorException) {
            throw new WizardStepException(noProcessorException);
        }
        logger.fine("Created processor " + this.processor);
        logger.fine("Configuring processor");
        this.stateWaiter = new StateWaiter(this.processor);
        if (!this.stateWaiter.blockingConfigure()) {
            throw new WizardStepException("Failed to configure processor");
        }
        logger.fine("Configured processor");
    }

    public void step2_setContentDescriptor(ProcessorWizardConfig processorWizardConfig) throws WizardStepException {
        if (this.processor.setContentDescriptor(processorWizardConfig.contentDescriptor) == null) {
            throw new WizardStepException("Unable to set content descriptor to " + processorWizardConfig.contentDescriptor);
        }
    }

    public void step3_setTrackConfigs(ProcessorWizardConfig processorWizardConfig) throws WizardStepException {
        TrackConfig[] trackConfigArray = processorWizardConfig.trackConfigs;
        TrackControl[] trackControlArray = this.processor.getTrackControls();
        for (int i = 0; i < trackControlArray.length; ++i) {
            Format format;
            Format format2;
            boolean bl = trackConfigArray[i].enabled;
            trackControlArray[i].setEnabled(bl);
            if (!bl || (format2 = trackControlArray[i].setFormat(format = trackConfigArray[i].format)) != null) continue;
            throw new WizardStepException("Unable to set format of track " + i + " to " + format);
        }
    }

    public void step4_setDestUrlAndStart(ProcessorWizardConfig processorWizardConfig) throws WizardStepException {
        if (!this.stateWaiter.blockingRealize()) {
            throw new WizardStepException("Failed to realize processor");
        }
        try {
            this.destDataSource = this.processor.getDataOutput();
        }
        catch (NotRealizedError notRealizedError) {
            throw new WizardStepException(notRealizedError);
        }
        try {
            String string = processorWizardConfig.destUrl;
            logger.fine("Dest url: " + string);
            MediaLocator mediaLocator = new MediaLocator(string);
            this.destDataSink = Manager.createDataSink(this.destDataSource, mediaLocator);
            this.destDataSink.open();
            this.destDataSink.start();
            logger.fine("Starting processor");
            this.stateWaiter.blockingStart();
        }
        catch (IOException iOException) {
            throw new WizardStepException(iOException);
        }
        catch (NoDataSinkException noDataSinkException) {
            throw new WizardStepException(noDataSinkException);
        }
    }
}

