/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetDesktopSharingServerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.InputEvtAction;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.InputEvtIQ;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.RemoteControlExtension;
import net.java.sip.communicator.service.protocol.AbstractOperationSetDesktopSharingClient;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.event.RemoteControlListener;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class OperationSetDesktopSharingClientJabberImpl
extends AbstractOperationSetDesktopSharingClient<ProtocolProviderServiceJabberImpl>
implements RegistrationStateChangeListener,
PacketListener,
PacketFilter {
    public OperationSetDesktopSharingClientJabberImpl(ProtocolProviderServiceJabberImpl parentProvider) {
        super((ProtocolProviderService)parentProvider);
        parentProvider.addRegistrationStateChangeListener(this);
    }

    public void sendKeyboardEvent(CallPeer callPeer, KeyEvent event) {
        RemoteControlExtension payload = new RemoteControlExtension(event);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    public void sendMouseEvent(CallPeer callPeer, MouseEvent event) {
        RemoteControlExtension payload = new RemoteControlExtension(event);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    public void sendMouseEvent(CallPeer callPeer, MouseEvent event, Dimension videoPanelSize) {
        RemoteControlExtension payload = new RemoteControlExtension(event, videoPanelSize);
        this.sendRemoteControlExtension(callPeer, payload);
    }

    private void sendRemoteControlExtension(CallPeer callPeer, RemoteControlExtension payload) {
        DiscoverInfo discoverInfo = ((CallPeerJabberImpl)callPeer).getDiscoveryInfo();
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getDiscoveryManager().includesFeature("http://jitsi.org/protocol/inputevt/sharee") && discoverInfo != null && discoverInfo.containsFeature("http://jitsi.org/protocol/inputevt/sharer")) {
            InputEvtIQ inputIQ = new InputEvtIQ();
            inputIQ.setAction(InputEvtAction.NOTIFY);
            inputIQ.setType(IQ.Type.SET);
            inputIQ.setFrom(((ProtocolProviderServiceJabberImpl)this.parentProvider).getOurJID());
            inputIQ.setTo(callPeer.getAddress());
            inputIQ.addRemoteControl(payload);
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)inputIQ);
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        OperationSetDesktopSharingServerJabberImpl.registrationStateChanged(evt, this, this, (Connection)((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection());
    }

    public void processPacket(Packet packet) {
        InputEvtIQ inputIQ = (InputEvtIQ)packet;
        if (inputIQ.getType() == IQ.Type.SET && inputIQ.getAction() != InputEvtAction.NOTIFY) {
            CallPeer callPeer;
            IQ ack = IQ.createResultIQ((IQ)inputIQ);
            ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)ack);
            String callPeerID = inputIQ.getFrom();
            if (callPeerID != null && (callPeer = this.getListenerCallPeer(callPeerID)) != null) {
                if (inputIQ.getAction() == InputEvtAction.START) {
                    this.fireRemoteControlGranted(callPeer);
                } else if (inputIQ.getAction() == InputEvtAction.STOP) {
                    this.fireRemoteControlRevoked(callPeer);
                }
            }
        }
    }

    public boolean accept(Packet packet) {
        return packet instanceof InputEvtIQ;
    }

    protected CallPeer getListenerCallPeer(String callPeerAddress) {
        List listeners = this.getListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            CallPeerJabberImpl callPeer = (CallPeerJabberImpl)((RemoteControlListener)listeners.get(i)).getCallPeer();
            if (!callPeer.getAddress().equals(callPeerAddress)) continue;
            return callPeer;
        }
        return null;
    }
}

