/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.jitsi.impl.neomedia.transform.srtp.OpenSSLDigest;
import org.jitsi.util.Logger;

public class SHA1 {
    private static final Logger logger = Logger.getLogger(SHA1.class);
    private static boolean useOpenSSL = true;

    public static Digest createDigest() {
        if (useOpenSSL) {
            try {
                return new OpenSSLDigest(1);
            }
            catch (Throwable t) {
                useOpenSSL = false;
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn("Failed to employ OpenSSL (Crypto) for an optimized SHA-1 implementation: " + t.getLocalizedMessage());
            }
        }
        return new SHA1Digest();
    }
}

