/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.rtp.rtcp.SourceDescription;
import net.sf.fmj.media.rtp.AbstractRTCPReportBuilder;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.RTCPTransmitter;
import net.sf.fmj.media.rtp.SSRCInfo;

public class DefaultRTCPReportBuilderImpl
extends AbstractRTCPReportBuilder {
    private int sdescounter;

    private RTCPReportBlock[] makeReceiverReports(RTCPTransmitter rtcpTransmitter, long time) {
        ArrayList<RTCPReportBlock> reports = new ArrayList<RTCPReportBlock>();
        Enumeration<SSRCInfo> elements = rtcpTransmitter.cache.cache.elements();
        while (elements.hasMoreElements()) {
            SSRCInfo info = elements.nextElement();
            if (info.ours || !info.sender) continue;
            reports.add(info.makeReceiverReport(time));
        }
        return reports.toArray(new RTCPReportBlock[reports.size()]);
    }

    public RTCPPacket[] makeReports(RTCPTransmitter rtcpTransmitter) {
        RTCPReportBlock[] reports;
        long time = System.currentTimeMillis();
        ArrayList<RTCPPacket> packets = new ArrayList<RTCPPacket>();
        SSRCInfo ourinfo = rtcpTransmitter.ssrcInfo;
        boolean senderreport = ourinfo.sender;
        RTCPReportBlock[] firstrep = reports = this.makeReceiverReports(rtcpTransmitter, time);
        if (reports.length > 31) {
            firstrep = new RTCPReportBlock[31];
            System.arraycopy(reports, 0, firstrep, 0, 31);
        }
        if (senderreport) {
            RTCPSRPacket srp = new RTCPSRPacket(ourinfo.ssrc, firstrep);
            packets.add(srp);
            long systime = ourinfo.systime == 0L ? System.currentTimeMillis() : ourinfo.systime;
            long secs = systime / 1000L;
            double msecs = (double)(systime - secs * 1000L) / 1000.0;
            srp.ntptimestamplsw = (int)(msecs * 4.294967296E9);
            srp.ntptimestampmsw = secs;
            srp.rtptimestamp = (int)ourinfo.rtptime;
            srp.packetcount = ourinfo.maxseq - ourinfo.baseseq;
            srp.octetcount = ourinfo.bytesreceived;
        } else {
            packets.add(new RTCPRRPacket(ourinfo.ssrc, firstrep));
        }
        if (firstrep != reports) {
            for (int offset = 31; offset < reports.length; offset += 31) {
                if (reports.length - offset < 31) {
                    firstrep = new RTCPReportBlock[reports.length - offset];
                }
                System.arraycopy(reports, offset, firstrep, 0, firstrep.length);
                packets.add(new RTCPRRPacket(ourinfo.ssrc, firstrep));
            }
        }
        ArrayList<RTCPSDESItem> sdes0Items = new ArrayList<RTCPSDESItem>(8);
        sdes0Items.add(new RTCPSDESItem(1, ourinfo.getCNAME()));
        if (this.sdescounter % 3 == 0) {
            String s;
            SourceDescription sd = ourinfo.name;
            if (sd != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(2, s));
            }
            if ((sd = ourinfo.email) != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(3, s));
            }
            if ((sd = ourinfo.phone) != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(4, s));
            }
            if ((sd = ourinfo.loc) != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(5, s));
            }
            if ((sd = ourinfo.tool) != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(6, s));
            }
            if ((sd = ourinfo.note) != null && (s = sd.getDescription()) != null) {
                sdes0Items.add(new RTCPSDESItem(7, s));
            }
        }
        ++this.sdescounter;
        RTCPSDES sdes0 = new RTCPSDES();
        sdes0.items = sdes0Items.toArray(new RTCPSDESItem[sdes0Items.size()]);
        sdes0.ssrc = rtcpTransmitter.ssrcInfo.ssrc;
        packets.add(new RTCPSDESPacket(new RTCPSDES[]{sdes0}));
        return packets.toArray(new RTCPPacket[packets.size()]);
    }

    public void reset() {
        this.sdescounter = 0;
    }
}

