/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

public class BurstMetrics {
    private static final short GMIN = 16;
    private long burstMetrics;
    private long c11;
    private long c13;
    private long c14;
    private long c22;
    private long c23;
    private long c33;
    private boolean calculate;
    private long discardCount;
    private long lossCount;
    private long lost;
    private long pkt;

    private synchronized void calculate() {
        long discardRate;
        long lossRate;
        long burstDuration;
        long gapDuration;
        long gapDensity;
        long burstDensity;
        double p32;
        long s1x = this.c11 + this.c13 + this.c14;
        long s2x = this.c22 + this.c23;
        long s3x = this.c13 + this.c23 + this.c33;
        long s = s1x + s2x + s3x;
        double p23 = this.c22 <= 0L ? 1.0 : 1.0 - (double)this.c22 / (double)s2x;
        double d = p32 = this.c23 <= 0L ? 0.0 : (double)this.c23 / (double)s3x;
        if (p23 <= 0.0) {
            burstDensity = 0L;
        } else {
            burstDensity = (long)(256.0 * p23 / (p23 + p32));
            if (burstDensity > 255L) {
                burstDensity = 255L;
            }
        }
        if (this.c14 <= 0L) {
            gapDensity = 0L;
        } else {
            gapDensity = (long)((double)(256L * this.c14) / (double)(this.c11 + this.c14));
            if (gapDensity > 255L) {
                gapDensity = 255L;
            }
        }
        int msPerPkt = 20;
        if (this.c13 <= 0L) {
            gapDuration = 0L;
            burstDuration = 0L;
        } else {
            gapDuration = s1x * (long)msPerPkt / this.c13;
            burstDuration = s * (long)msPerPkt / this.c13 - gapDuration;
        }
        if (s <= 0L) {
            lossRate = 0L;
            discardRate = 0L;
        } else {
            lossRate = 256L * this.lossCount / s;
            if (lossRate > 255L) {
                lossRate = 255L;
            }
            if ((discardRate = 256L * this.discardCount / s) > 255L) {
                discardRate = 255L;
            }
        }
        this.burstMetrics = lossRate & 0xFFL;
        this.burstMetrics <<= 8;
        this.burstMetrics |= discardRate & 0xFFL;
        this.burstMetrics <<= 8;
        this.burstMetrics |= burstDensity & 0xFFL;
        this.burstMetrics <<= 8;
        this.burstMetrics |= gapDensity & 0xFFL;
        this.burstMetrics <<= 8;
        this.burstMetrics |= burstDuration & 0xFFFFL;
        this.burstMetrics <<= 16;
        this.burstMetrics |= gapDuration & 0xFFFFL;
        this.calculate = false;
    }

    public synchronized long getBurstMetrics() {
        if (this.calculate) {
            this.calculate();
        }
        return this.burstMetrics;
    }

    public short getGMin() {
        return 16;
    }

    public synchronized void update(int which) {
        boolean calculate;
        if (which == 0) {
            ++this.lossCount;
            calculate = true;
        } else if (which == 8) {
            ++this.discardCount;
            calculate = true;
        } else {
            ++this.pkt;
            calculate = false;
        }
        if (calculate) {
            if (this.pkt >= 16L) {
                if (this.lost == 1L) {
                    ++this.c14;
                } else {
                    ++this.c13;
                    this.lost = 1L;
                }
                this.c11 += this.pkt;
            } else {
                ++this.lost;
                if (this.pkt == 0L) {
                    ++this.c33;
                } else {
                    ++this.c23;
                    this.c22 += this.pkt - 1L;
                }
            }
            this.pkt = 0L;
            this.calculate = true;
        }
    }
}

