/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.frames.HeadersFrame;
import org.eclipse.jetty.spdy.parser.ControlFrameBodyParser;
import org.eclipse.jetty.spdy.parser.ControlFrameParser;
import org.eclipse.jetty.spdy.parser.HeadersBlockParser;
import org.eclipse.jetty.util.Fields;

public class HeadersBodyParser
extends ControlFrameBodyParser {
    private final Fields headers = new Fields();
    private final ControlFrameParser controlFrameParser;
    private final HeadersBlockParser headersBlockParser;
    private State state = State.STREAM_ID;
    private int cursor;
    private int streamId;

    public HeadersBodyParser(CompressionFactory.Decompressor decompressor, ControlFrameParser controlFrameParser) {
        this.controlFrameParser = controlFrameParser;
        this.headersBlockParser = new HeadersHeadersBlockParser(decompressor);
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block11: while (buffer.hasRemaining()) {
            switch (this.state) {
                case STREAM_ID: {
                    if (buffer.remaining() >= 4) {
                        this.streamId = buffer.getInt() & Integer.MAX_VALUE;
                        this.state = State.ADDITIONAL;
                        continue block11;
                    }
                    this.state = State.STREAM_ID_BYTES;
                    this.cursor = 4;
                    continue block11;
                }
                case STREAM_ID_BYTES: {
                    byte currByte = buffer.get();
                    --this.cursor;
                    this.streamId += (currByte & 0xFF) << 8 * this.cursor;
                    if (this.cursor != 0) continue block11;
                    this.streamId &= Integer.MAX_VALUE;
                    this.state = State.ADDITIONAL;
                    continue block11;
                }
                case ADDITIONAL: {
                    switch (this.controlFrameParser.getVersion()) {
                        case 2: {
                            if (buffer.remaining() >= 2) {
                                buffer.getShort();
                                this.state = State.HEADERS;
                                continue block11;
                            }
                            this.state = State.ADDITIONAL_BYTES;
                            this.cursor = 2;
                            continue block11;
                        }
                        case 3: {
                            this.state = State.HEADERS;
                            continue block11;
                        }
                    }
                    throw new IllegalStateException();
                }
                case ADDITIONAL_BYTES: {
                    assert (this.controlFrameParser.getVersion() == 2);
                    buffer.get();
                    --this.cursor;
                    if (this.cursor != 0) continue block11;
                    this.state = State.HEADERS;
                    continue block11;
                }
                case HEADERS: {
                    short version = this.controlFrameParser.getVersion();
                    int length = this.controlFrameParser.getLength() - 4;
                    if (version == 2) {
                        length -= 2;
                    }
                    if (!this.headersBlockParser.parse(this.streamId, version, length, buffer)) continue block11;
                    byte flags = this.controlFrameParser.getFlags();
                    if (flags != 0 && flags != 1 && flags != 2) {
                        throw new IllegalArgumentException("Invalid flag " + flags + " for frame " + (Object)((Object)ControlFrameType.HEADERS));
                    }
                    HeadersFrame frame = new HeadersFrame(version, flags, this.streamId, new Fields(this.headers, true));
                    this.controlFrameParser.onControlFrame(frame);
                    this.reset();
                    return true;
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private void reset() {
        this.headers.clear();
        this.state = State.STREAM_ID;
        this.cursor = 0;
        this.streamId = 0;
    }

    private class HeadersHeadersBlockParser
    extends HeadersBlockParser {
        public HeadersHeadersBlockParser(CompressionFactory.Decompressor decompressor) {
            super(decompressor);
        }

        @Override
        protected void onHeader(String name, String[] values) {
            for (String value : values) {
                HeadersBodyParser.this.headers.add(name, value);
            }
        }
    }

    private static enum State {
        STREAM_ID,
        STREAM_ID_BYTES,
        ADDITIONAL,
        ADDITIONAL_BYTES,
        HEADERS;

    }
}

