/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.WebRtcDataStream;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends PropertyChangeNotifier
implements WebRtcDataStream.DataCallback {
    public static final String CHANNELS_PROPERTY_NAME = Endpoint.class.getName() + ".channels";
    private static final Logger logger = Logger.getLogger(Endpoint.class);
    public static final String SCTP_CONNECTION_PROPERTY_NAME = Endpoint.class.getName() + ".sctpConnection";
    public static final String SELECTED_ENDPOINT_NOT_WATCHING_VIDEO = "SELECTED_ENDPOINT_NOT_WATCHING_VIDEO";
    public static final String SELECTED_ENDPOINT_PROPERTY_NAME = Endpoint.class.getName() + ".selectedEndpoint";
    public static final String PINNED_ENDPOINT_PROPERTY_NAME = Endpoint.class.getName() + ".pinnedEndpoint";
    private final List<WeakReference<RtpChannel>> channels = new LinkedList<WeakReference<RtpChannel>>();
    private String displayName;
    private final String id;
    private WeakReference<SctpConnection> sctpConnection = new WeakReference<Object>(null);
    private String selectedEndpointID;
    private final Object selectedEndpointSyncRoot = new Object();
    private String pinnedEndpointID;
    private final Object pinnedEndpointSyncRoot = new Object();

    public Endpoint(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannel(RtpChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (channel.isExpired()) {
            return false;
        }
        boolean added = false;
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            boolean add = true;
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (c.equals(channel)) {
                    add = false;
                    continue;
                }
                if (!c.isExpired()) continue;
                i.remove();
                removed = true;
            }
            if (add) {
                this.channels.add(new WeakReference<RtpChannel>(channel));
                added = true;
            }
        }
        if (added || removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return added;
    }

    void audioLevelChanged(Channel channel, long ssrc, int audioLevel) {
    }

    public int getChannelCount(MediaType mediaType) {
        return this.getChannels(mediaType).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RtpChannel> getChannels(MediaType mediaType) {
        boolean removed = false;
        LinkedList<RtpChannel> channels = new LinkedList<RtpChannel>();
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                RtpChannel c = (RtpChannel)i.next().get();
                if (c == null || c.isExpired()) {
                    i.remove();
                    removed = true;
                    continue;
                }
                if (mediaType != null && !mediaType.equals((Object)c.getContent().getMediaType())) continue;
                channels.add(c);
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return channels;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final String getID() {
        return this.id;
    }

    public SctpConnection getSctpConnection() {
        return (SctpConnection)((Object)this.sctpConnection.get());
    }

    public String getSelectedEndpointID() {
        return this.selectedEndpointID;
    }

    public String getPinnedEndpointID() {
        return this.pinnedEndpointID;
    }

    @Override
    public void onBinaryData(WebRtcDataStream src, byte[] data) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStringData(WebRtcDataStream src, String msg) {
        JSONObject jsonObject;
        JSONParser parser = new JSONParser();
        try {
            Object obj = parser.parse(msg);
            if (!(obj instanceof JSONObject)) {
                return;
            }
            jsonObject = (JSONObject)obj;
        }
        catch (ParseException e) {
            logger.warn((Object)("Malformed JSON received from endpoint " + this.getID()), (Throwable)e);
            return;
        }
        Object colibriClass = jsonObject.get((Object)"colibriClass");
        if (colibriClass != null) {
            if ("SelectedEndpointChangedEvent".equals(colibriClass)) {
                boolean changed;
                String newSelectedEndpoint;
                String oldSelectedEndpoint;
                Object object = this.selectedEndpointSyncRoot;
                synchronized (object) {
                    oldSelectedEndpoint = this.selectedEndpointID;
                    newSelectedEndpoint = (String)jsonObject.get((Object)"selectedEndpoint");
                    newSelectedEndpoint = newSelectedEndpoint == null || newSelectedEndpoint.length() == 0 ? SELECTED_ENDPOINT_NOT_WATCHING_VIDEO : newSelectedEndpoint.trim();
                    boolean bl = changed = !newSelectedEndpoint.equals(oldSelectedEndpoint);
                    if (changed) {
                        this.selectedEndpointID = newSelectedEndpoint;
                    }
                }
                if (changed) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Endpoint " + this.getID() + " selected " + newSelectedEndpoint));
                    }
                    this.firePropertyChange(SELECTED_ENDPOINT_PROPERTY_NAME, oldSelectedEndpoint, newSelectedEndpoint);
                }
            } else if ("PinnedEndpointChangedEvent".equals(colibriClass)) {
                boolean changed;
                String newPinnedEndpoint;
                String oldPinnedEndpoint;
                Object object = this.pinnedEndpointSyncRoot;
                synchronized (object) {
                    oldPinnedEndpoint = this.pinnedEndpointID;
                    newPinnedEndpoint = (String)jsonObject.get((Object)"pinnedEndpoint");
                    newPinnedEndpoint = newPinnedEndpoint == null ? "" : newPinnedEndpoint.trim();
                    boolean bl = changed = !newPinnedEndpoint.equals(oldPinnedEndpoint);
                    if (changed) {
                        this.pinnedEndpointID = newPinnedEndpoint;
                    }
                }
                if (changed) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Endpoint " + this.getID() + " pinned " + newPinnedEndpoint));
                    }
                    this.firePropertyChange(PINNED_ENDPOINT_PROPERTY_NAME, oldPinnedEndpoint, newPinnedEndpoint);
                }
            }
        } else {
            logger.warn((Object)("Malformed JSON received from endpoint " + this.getID() + ". JSON object does not contain the colibriClass" + " field."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannel(RtpChannel channel) {
        if (channel == null) {
            return false;
        }
        boolean removed = false;
        List<WeakReference<RtpChannel>> list = this.channels;
        synchronized (list) {
            Iterator<WeakReference<RtpChannel>> i = this.channels.iterator();
            while (i.hasNext()) {
                Channel c = (Channel)((Object)i.next().get());
                if (c != null && !((Object)((Object)c)).equals(channel) && !c.isExpired()) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.firePropertyChange(CHANNELS_PROPERTY_NAME, null, null);
        }
        return removed;
    }

    void sctpConnectionReady(SctpConnection sctpConnection) {
        if (((Object)((Object)sctpConnection)).equals((Object)this.getSctpConnection()) && !sctpConnection.isExpired() && sctpConnection.isReady()) {
            for (RtpChannel channel : this.getChannels(null)) {
                channel.sctpConnectionReady(this);
            }
            try {
                WebRtcDataStream dataStream = sctpConnection.getDefaultDataStream();
                dataStream.setDataCallback(this);
            }
            catch (IOException e) {
                logger.error((Object)"Could not get the default data stream.", (Throwable)e);
            }
        }
    }

    public void sendMessageOnDataChannel(String msg) throws IOException {
        SctpConnection sctpConnection = this.getSctpConnection();
        String endpointId = this.getID();
        if (sctpConnection == null) {
            logger.warn((Object)("No SCTP connection with " + endpointId + "."));
        } else if (sctpConnection.isReady()) {
            WebRtcDataStream dataStream = sctpConnection.getDefaultDataStream();
            if (dataStream == null) {
                logger.warn((Object)("WebRtc data channel with " + endpointId + " not opened yet."));
            }
            dataStream.sendString(msg);
        } else {
            logger.warn((Object)("SCTP connection with " + endpointId + " not ready yet."));
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setSctpConnection(SctpConnection sctpConnection) {
        SctpConnection oldValue = this.getSctpConnection();
        if (sctpConnection == null ? oldValue != null : !((Object)((Object)sctpConnection)).equals((Object)oldValue)) {
            this.sctpConnection = new WeakReference<SctpConnection>(sctpConnection);
            this.firePropertyChange(SCTP_CONNECTION_PROPERTY_NAME, (Object)oldValue, (Object)this.getSctpConnection());
        }
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getID();
    }
}

