/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.util.Logger;
import org.jitsi.util.event.PropertyChangeNotifier;
import org.jitsi.util.event.WeakReferencePropertyChangeListener;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.ConferenceSpeechActivity;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.EndpointRecorder;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RecorderEventHandlerImpl;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.SctpConnection;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.WebRtcDataStreamAdapter;
import org.jitsi.videobridge.WebRtcDataStreamListener;
import org.jitsi.videobridge.log.EventFactory;
import org.jitsi.videobridge.log.LoggingService;
import org.jitsi.videobridge.metrics.MetricService;
import org.json.simple.JSONValue;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conference
extends PropertyChangeNotifier
implements PropertyChangeListener {
    public static final String ENDPOINTS_PROPERTY_NAME = Conference.class.getName() + ".endpoints";
    private static final Logger logger = Logger.getLogger(Conference.class);
    private final List<Content> contents = new LinkedList<Content>();
    private EndpointRecorder endpointRecorder = null;
    private final List<WeakReference<Endpoint>> endpoints = new LinkedList<WeakReference<Endpoint>>();
    private boolean expired = false;
    private final String focus;
    private final String id;
    private long lastActivityTime;
    private String lastKnownFocus;
    private final PropertyChangeListener propertyChangeListener = new WeakReferencePropertyChangeListener((PropertyChangeListener)this);
    private RecorderEventHandlerImpl recorderEventHandler = null;
    private boolean recording = false;
    private String recordingDirectory = null;
    private String recordingPath = null;
    private final ConferenceSpeechActivity speechActivity;
    private final Map<String, IceUdpTransportManager> transportManagers = new HashMap<String, IceUdpTransportManager>();
    private final Videobridge videobridge;
    private final WebRtcDataStreamListener webRtcDataStreamListener = new WebRtcDataStreamAdapter(){

        public void onSctpConnectionReady(SctpConnection source) {
            Conference.this.sctpConnectionReady(source);
        }
    };

    public Conference(Videobridge videobridge, String id, String focus) {
        if (videobridge == null) {
            throw new NullPointerException("videobridge");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.videobridge = videobridge;
        this.id = id;
        this.focus = focus;
        this.lastKnownFocus = focus;
        this.speechActivity = new ConferenceSpeechActivity(this);
        this.speechActivity.addPropertyChangeListener(this.propertyChangeListener);
        LoggingService loggingService = videobridge.getLoggingService();
        if (loggingService != null) {
            loggingService.logEvent(EventFactory.conferenceCreated(id, focus));
        }
    }

    private void broadcastMessageOnDataChannels(String msg) {
        for (Endpoint endpoint : this.getEndpoints()) {
            try {
                endpoint.sendMessageOnDataChannel(msg);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to send message on data channel.", (Throwable)e);
            }
        }
    }

    private boolean checkRecordingDirectory(String path) {
        if (path == null || "".equals(path)) {
            return false;
        }
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
            if (!dir.exists()) {
                return false;
            }
        }
        return dir.isDirectory() && dir.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeTransportManager(TransportManager transportManager) {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            block12: {
                String managerBundleId = null;
                for (String bundleID : this.transportManagers.keySet()) {
                    if (transportManager != this.transportManagers.get(bundleID)) continue;
                    managerBundleId = bundleID;
                    break;
                }
                try {
                    transportManager.close();
                    if (managerBundleId == null) break block12;
                    this.transportManagers.remove(managerBundleId);
                }
                catch (Throwable t) {
                    try {
                        logger.warn((Object)("Failed to close an IceUdpTransportManager of conference " + this.getID() + "!"), t);
                        if (t instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        } else if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        if (managerBundleId == null) break block12;
                        this.transportManagers.remove(managerBundleId);
                    }
                    catch (Throwable throwable) {
                        if (managerBundleId != null) {
                            this.transportManagers.remove(managerBundleId);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTransportManagers() {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            for (IceUdpTransportManager transportManager : this.transportManagers.values()) {
                this.closeTransportManager(transportManager);
            }
        }
    }

    private String createDominantSpeakerEndpointChangeEvent(Endpoint dominantSpeaker) {
        return "{\"colibriClass\":\"DominantSpeakerEndpointChangeEvent\",\"dominantSpeakerEndpoint\":\"" + JSONValue.escape((String)dominantSpeaker.getID()) + "\"}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void describeChannelBundles(ColibriConferenceIQ iq) {
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            for (Map.Entry<String, IceUdpTransportManager> entry : this.transportManagers.entrySet()) {
                ColibriConferenceIQ.ChannelBundle responseBundleIQ = new ColibriConferenceIQ.ChannelBundle(entry.getKey());
                entry.getValue().describe(responseBundleIQ);
                iq.addChannelBundle(responseBundleIQ);
            }
        }
    }

    public void describeDeep(ColibriConferenceIQ iq) {
        this.describeShallow(iq);
        if (this.isRecording()) {
            ColibriConferenceIQ.Recording recordingIQ = new ColibriConferenceIQ.Recording(true);
            recordingIQ.setDirectory(this.getRecordingDirectory());
            iq.setRecording(recordingIQ);
        }
        for (Content content : this.getContents()) {
            ColibriConferenceIQ.Content contentIQ = iq.getOrCreateContent(content.getName());
            for (Channel channel : content.getChannels()) {
                if (channel instanceof SctpConnection) {
                    ColibriConferenceIQ.SctpConnection sctpConnectionIQ = new ColibriConferenceIQ.SctpConnection();
                    channel.describe((ColibriConferenceIQ.ChannelCommon)sctpConnectionIQ);
                    contentIQ.addSctpConnection(sctpConnectionIQ);
                    continue;
                }
                ColibriConferenceIQ.Channel channelIQ = new ColibriConferenceIQ.Channel();
                channel.describe((ColibriConferenceIQ.ChannelCommon)channelIQ);
                contentIQ.addChannel(channelIQ);
            }
        }
    }

    public void describeShallow(ColibriConferenceIQ iq) {
        iq.setID(this.getID());
    }

    private void dominantSpeakerChanged() {
        Endpoint dominantSpeaker = this.speechActivity.getDominantEndpoint();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("The dominant speaker in conference " + this.getID() + " is now the endpoint " + (dominantSpeaker == null ? "(null)" : dominantSpeaker.getID()) + "."));
        }
        if (dominantSpeaker != null) {
            this.broadcastMessageOnDataChannels(this.createDominantSpeakerEndpointChangeEvent(dominantSpeaker));
            if (this.isRecording() && this.recorderEventHandler != null) {
                this.recorderEventHandler.dominantSpeakerChanged(dominantSpeaker);
            }
        }
    }

    private void endpointPropertyChange(Endpoint endpoint, PropertyChangeEvent ev) {
        boolean maybeRemoveEndpoint;
        String propertyName = ev.getPropertyName();
        if (Endpoint.SCTP_CONNECTION_PROPERTY_NAME.equals(propertyName)) {
            SctpConnection oldValue = (SctpConnection)((Object)ev.getOldValue());
            SctpConnection newValue = (SctpConnection)((Object)ev.getNewValue());
            this.endpointSctpConnectionChanged(endpoint, oldValue, newValue);
            maybeRemoveEndpoint = newValue == null;
        } else {
            maybeRemoveEndpoint = Endpoint.CHANNELS_PROPERTY_NAME.equals(propertyName);
        }
        if (maybeRemoveEndpoint && endpoint.getSctpConnection() == null && endpoint.getChannelCount(null) == 0) {
            this.removeEndpoint(endpoint);
        }
    }

    private void endpointSctpConnectionChanged(Endpoint endpoint, SctpConnection oldValue, SctpConnection newValue) {
        if (oldValue != null) {
            oldValue.removeChannelListener(this.webRtcDataStreamListener);
        }
        if (newValue != null) {
            newValue.addChannelListener(this.webRtcDataStreamListener);
            if (newValue.isReady()) {
                this.sctpConnectionReady(newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        MetricService metricService2;
        Conference conference = this;
        synchronized (conference) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        LoggingService loggingService = this.videobridge.getLoggingService();
        if (loggingService != null) {
            loggingService.logEvent(EventFactory.conferenceExpired(this.id));
        }
        this.setRecording(false);
        if (this.recorderEventHandler != null) {
            this.recorderEventHandler.close();
            this.recorderEventHandler = null;
        }
        Videobridge videobridge = this.getVideobridge();
        try {
            videobridge.expireConference(this);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            MetricService metricService2;
            Object var4_5 = null;
            for (Content content : this.getContents()) {
                try {
                    content.expire();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            this.closeTransportManagers();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Expired conference " + this.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
            }
            if ((metricService2 = videobridge.getMetricService()) != null) {
                metricService2.publishNumericMetric("Conferences", videobridge.getConferenceCount());
                metricService2.endMeasuredTransaction("Conference length", this.getID());
            }
            throw throwable;
        }
        for (Content content : this.getContents()) {
            try {
                content.expire();
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        this.closeTransportManagers();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Expired conference " + this.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
        }
        if ((metricService2 = videobridge.getMetricService()) != null) {
            metricService2.publishNumericMetric("Conferences", videobridge.getConferenceCount());
            metricService2.endMeasuredTransaction("Conference length", this.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireContent(Content content) {
        boolean expireContent;
        List<Content> list = this.contents;
        synchronized (list) {
            if (this.contents.contains(content)) {
                this.contents.remove(content);
                expireContent = true;
            } else {
                expireContent = false;
            }
        }
        if (expireContent) {
            content.expire();
        }
    }

    public Channel findChannelByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        for (Content content : this.getContents()) {
            Channel channel;
            if (!mediaType.equals((Object)content.getMediaType()) || (channel = content.findChannelByReceiveSSRC(receiveSSRC)) == null) continue;
            return channel;
        }
        return null;
    }

    Endpoint findEndpointByReceiveSSRC(long receiveSSRC, MediaType mediaType) {
        Channel channel = this.findChannelByReceiveSSRC(receiveSSRC, mediaType);
        return channel == null ? null : channel.getEndpoint();
    }

    public BundleContext getBundleContext() {
        return this.getVideobridge().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content[] getContents() {
        List<Content> list = this.contents;
        synchronized (list) {
            return this.contents.toArray(new Content[this.contents.size()]);
        }
    }

    public Endpoint getEndpoint(String id) {
        return this.getEndpoint(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Endpoint getEndpoint(String id, boolean create) {
        Endpoint endpoint = null;
        boolean changed = false;
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint e = (Endpoint)i.next().get();
                if (e == null) {
                    i.remove();
                    changed = true;
                    continue;
                }
                if (!e.getID().equals(id)) continue;
                endpoint = e;
            }
            if (create && endpoint == null) {
                endpoint = new Endpoint(id);
                endpoint.addPropertyChangeListener(this.propertyChangeListener);
                this.endpoints.add(new WeakReference<Endpoint>(endpoint));
                changed = true;
                LoggingService loggingService = this.videobridge.getLoggingService();
                if (loggingService != null) {
                    loggingService.logEvent(EventFactory.endpointCreated(this.getID(), id));
                }
            }
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return endpoint;
    }

    public int getEndpointCount() {
        return this.getEndpoints().size();
    }

    private EndpointRecorder getEndpointRecorder() {
        if (this.endpointRecorder == null) {
            try {
                this.endpointRecorder = new EndpointRecorder(this.getRecordingPath() + "/endpoints.json");
            }
            catch (IOException ioe) {
                logger.warn((Object)("Could not create EndpointRecorder. " + ioe));
            }
        }
        return this.endpointRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> getEndpoints() {
        ArrayList<Endpoint> endpoints;
        boolean changed = false;
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            endpoints = new ArrayList<Endpoint>(this.endpoints.size());
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint endpoint = (Endpoint)i.next().get();
                if (endpoint == null) {
                    i.remove();
                    changed = true;
                    continue;
                }
                endpoints.add(endpoint);
            }
        }
        if (changed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return endpoints;
    }

    public final String getFocus() {
        return this.focus;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Conference conference = this;
        synchronized (conference) {
            return this.lastActivityTime;
        }
    }

    public String getLastKnowFocus() {
        return this.lastKnownFocus;
    }

    MediaService getMediaService() {
        MediaService mediaService = (MediaService)ServiceUtils.getService((BundleContext)this.getBundleContext(), MediaService.class);
        if (mediaService == null) {
            mediaService = LibJitsi.getMediaService();
        }
        return mediaService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content getOrCreateContent(String name) {
        Content content;
        List<Content> list = this.contents;
        synchronized (list) {
            for (Content aContent : this.contents) {
                if (!aContent.getName().equals(name)) continue;
                aContent.touch();
                return aContent;
            }
            content = new Content(this, name);
            if (this.isRecording()) {
                content.setRecording(true, this.getRecordingPath());
            }
            this.contents.add(content);
        }
        if (logger.isInfoEnabled()) {
            Videobridge videobridge = this.getVideobridge();
            logger.info((Object)("Created content " + name + " of conference " + this.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + "."));
        }
        return content;
    }

    public Endpoint getOrCreateEndpoint(String id) {
        return this.getEndpoint(id, true);
    }

    RecorderEventHandler getRecorderEventHandler() {
        if (this.recorderEventHandler == null) {
            Exception t;
            try {
                this.recorderEventHandler = new RecorderEventHandlerImpl(this, this.getMediaService().createRecorderEventHandlerJson(this.getRecordingPath() + "/metadata.json"));
                t = null;
            }
            catch (IOException ioe) {
                t = ioe;
            }
            catch (IllegalArgumentException iae) {
                t = iae;
            }
            if (t != null) {
                logger.warn((Object)("Could not create RecorderEventHandler. " + t));
            }
        }
        return this.recorderEventHandler;
    }

    String getRecordingDirectory() {
        if (this.recordingDirectory == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss.");
            this.recordingDirectory = dateFormat.format(new Date()) + this.getID();
        }
        return this.recordingDirectory;
    }

    String getRecordingPath() {
        String path;
        boolean recordingIsEnabled;
        ConfigurationService cfg;
        if (this.recordingPath == null && (cfg = this.getVideobridge().getConfigurationService()) != null && (recordingIsEnabled = cfg.getBoolean("org.jitsi.videobridge.ENABLE_MEDIA_RECORDING", false)) && (path = cfg.getString("org.jitsi.videobridge.MEDIA_RECORDING_PATH", null)) != null) {
            this.recordingPath = path + "/" + this.getRecordingDirectory();
        }
        return this.recordingPath;
    }

    public ConferenceSpeechActivity getSpeechActivity() {
        return this.speechActivity;
    }

    TransportManager getTransportManager(String channelBundleId) {
        return this.getTransportManager(channelBundleId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IceUdpTransportManager getTransportManager(String channelBundleId, boolean create) {
        IceUdpTransportManager transportManager;
        Map<String, IceUdpTransportManager> map = this.transportManagers;
        synchronized (map) {
            transportManager = this.transportManagers.get(channelBundleId);
            if (transportManager == null && create && !this.isExpired()) {
                try {
                    transportManager = new IceUdpTransportManager(this, true, 1);
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                this.transportManagers.put(channelBundleId, transportManager);
            }
        }
        return transportManager;
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    public boolean isExpired() {
        return this.expired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        boolean recording = this.recording;
        if (recording) {
            List<Content> list = this.contents;
            synchronized (list) {
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.VIDEO.equals((Object)mediaType) && !MediaType.AUDIO.equals((Object)mediaType) || content.isRecording()) continue;
                    recording = false;
                }
            }
        }
        if (this.recording != recording) {
            this.setRecording(recording);
        }
        return this.recording;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        Endpoint endpoint;
        Object source = ev.getSource();
        if (this.isExpired()) {
            if (source instanceof PropertyChangeNotifier) {
                ((PropertyChangeNotifier)source).removePropertyChangeListener(this.propertyChangeListener);
            }
        } else if (source == this.speechActivity) {
            this.speechActivityPropertyChange(ev);
        } else if (source instanceof Endpoint && (endpoint = this.getEndpoint(((Endpoint)source).getID())) != null) {
            this.endpointPropertyChange(endpoint, ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeEndpoint(Endpoint endpoint) {
        boolean removed = false;
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint e = (Endpoint)i.next().get();
                if (e != null && e != endpoint) continue;
                i.remove();
                removed = true;
            }
        }
        if (removed) {
            this.firePropertyChange(ENDPOINTS_PROPERTY_NAME, null, null);
        }
        return removed;
    }

    private void sctpConnectionReady(SctpConnection sctpConnection) {
        sctpConnection.removeChannelListener(this.webRtcDataStreamListener);
        if (!this.isExpired() && !sctpConnection.isExpired() && sctpConnection.isReady()) {
            Endpoint endpoint = sctpConnection.getEndpoint();
            if (endpoint != null) {
                endpoint = this.getEndpoint(endpoint.getID());
            }
            if (endpoint != null) {
                Endpoint dominantSpeaker = this.speechActivity.getDominantEndpoint();
                if (dominantSpeaker != null) {
                    try {
                        endpoint.sendMessageOnDataChannel(this.createDominantSpeakerEndpointChangeEvent(dominantSpeaker));
                    }
                    catch (IOException e) {
                        logger.error((Object)"Failed to send message on data channel.", (Throwable)e);
                    }
                }
                endpoint.sctpConnectionReady(sctpConnection);
            }
        }
    }

    public void setLastKnownFocus(String jid) {
        this.lastKnownFocus = jid;
    }

    public boolean setRecording(boolean recording) {
        if (recording != this.recording) {
            if (recording) {
                RecorderEventHandler handler;
                String path;
                boolean failedToStart;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Starting recording for conference with id=" + this.getID()));
                }
                boolean bl = failedToStart = !this.checkRecordingDirectory(path = this.getRecordingPath());
                if (!failedToStart && (handler = this.getRecorderEventHandler()) == null) {
                    failedToStart = true;
                }
                if (!failedToStart) {
                    EndpointRecorder endpointRecorder = this.getEndpointRecorder();
                    if (endpointRecorder == null) {
                        failedToStart = true;
                    } else {
                        for (Endpoint endpoint : this.getEndpoints()) {
                            endpointRecorder.updateEndpoint(endpoint);
                        }
                    }
                }
                boolean first = true;
                Synchronizer synchronizer = null;
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.VIDEO.equals((Object)mediaType) && !MediaType.AUDIO.equals((Object)mediaType)) continue;
                    if (!failedToStart) {
                        boolean bl2 = failedToStart = !content.setRecording(true, path);
                    }
                    if (failedToStart) break;
                    if (first) {
                        first = false;
                        synchronizer = content.getRecorder().getSynchronizer();
                    } else {
                        Recorder recorder = content.getRecorder();
                        if (recorder != null) {
                            recorder.setSynchronizer(synchronizer);
                        }
                    }
                    content.feedKnownSsrcsToSynchronizer();
                }
                if (failedToStart) {
                    recording = false;
                    logger.warn((Object)("Failed to start media recording for conference " + this.getID()));
                }
            }
            if (!recording) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Stopping recording for conference with id=" + this.getID()));
                }
                for (Content content : this.contents) {
                    MediaType mediaType = content.getMediaType();
                    if (!MediaType.AUDIO.equals((Object)mediaType) && !MediaType.VIDEO.equals((Object)mediaType)) continue;
                    content.setRecording(false, null);
                }
                if (this.recorderEventHandler != null) {
                    this.recorderEventHandler.close();
                }
                this.recorderEventHandler = null;
                this.recordingPath = null;
                this.recordingDirectory = null;
                if (this.endpointRecorder != null) {
                    this.endpointRecorder.close();
                }
                this.endpointRecorder = null;
            }
            this.recording = recording;
        }
        return this.recording;
    }

    private void speechActivityEndpointsChanged() {
        List<Endpoint> endpoints = null;
        for (Content content : this.getContents()) {
            if (!MediaType.VIDEO.equals((Object)content.getMediaType())) continue;
            HashSet<Endpoint> endpointsToAskForKeyframes = null;
            endpoints = this.speechActivity.getEndpoints();
            for (Channel channel : content.getChannels()) {
                RtpChannel rtpChannel = (RtpChannel)channel;
                List<Endpoint> channelEndpointsToAskForKeyframes = rtpChannel.speechActivityEndpointsChanged(endpoints);
                if (channelEndpointsToAskForKeyframes == null || channelEndpointsToAskForKeyframes.isEmpty()) continue;
                if (endpointsToAskForKeyframes == null) {
                    endpointsToAskForKeyframes = new HashSet<Endpoint>();
                }
                endpointsToAskForKeyframes.addAll(channelEndpointsToAskForKeyframes);
            }
            if (endpointsToAskForKeyframes == null || endpointsToAskForKeyframes.isEmpty()) continue;
            content.askForKeyframes((Collection<Endpoint>)endpointsToAskForKeyframes);
        }
    }

    private void speechActivityPropertyChange(PropertyChangeEvent ev) {
        String propertyName = ev.getPropertyName();
        if (ConferenceSpeechActivity.DOMINANT_ENDPOINT_PROPERTY_NAME.equals(propertyName)) {
            this.dominantSpeakerChanged();
        } else if (ConferenceSpeechActivity.ENDPOINTS_PROPERTY_NAME.equals(propertyName)) {
            this.speechActivityEndpointsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Conference conference = this;
        synchronized (conference) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    void updateEndpoint(ColibriConferenceIQ.Endpoint colibriEndpoint) {
        Endpoint endpoint;
        String id = colibriEndpoint.getId();
        if (id != null && (endpoint = this.getEndpoint(id)) != null) {
            String oldDisplayName = endpoint.getDisplayName();
            String newDisplayName = colibriEndpoint.getDisplayName();
            if (oldDisplayName == null && newDisplayName != null || oldDisplayName != null && !oldDisplayName.equals(newDisplayName)) {
                LoggingService loggingService;
                endpoint.setDisplayName(newDisplayName);
                if (this.isRecording() && this.endpointRecorder != null) {
                    this.endpointRecorder.updateEndpoint(endpoint);
                }
                if ((loggingService = this.getVideobridge().getLoggingService()) != null) {
                    loggingService.logEvent(EventFactory.endpointDisplayNameChanged(this.getID(), id, newDisplayName));
                }
            }
        }
    }
}

