/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.nio.IOService;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.PortableContext;
import com.hazelcast.nio.tcp.PacketReader;
import com.hazelcast.nio.tcp.TcpIpConnection;
import java.nio.ByteBuffer;

public class DefaultPacketReader
implements PacketReader {
    protected final TcpIpConnection connection;
    protected final IOService ioService;
    protected Packet packet;

    public DefaultPacketReader(TcpIpConnection connection, IOService ioService) {
        this.connection = connection;
        this.ioService = ioService;
    }

    @Override
    public void readPacket(ByteBuffer inBuffer) throws Exception {
        while (inBuffer.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = this.obtainPacket();
            }
            if (!(complete = this.packet.readFrom(inBuffer))) break;
            this.packet.setConn(this.connection);
            this.ioService.handleMemberPacket(this.packet);
            this.packet = null;
        }
    }

    protected Packet obtainPacket() {
        PortableContext portableContext = this.ioService.getPortableContext();
        return new Packet(portableContext);
    }
}

