/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong.client;

import com.hazelcast.client.ClientEngine;
import com.hazelcast.client.impl.client.PartitionClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.atomiclong.client.AtomicLongPortableHook;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.AtomicLongPermission;
import java.io.IOException;
import java.security.Permission;

public abstract class AtomicLongRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    protected String name;
    protected long delta;

    protected AtomicLongRequest() {
    }

    protected AtomicLongRequest(String name, long delta) {
        this.name = name;
        this.delta = delta;
    }

    @Override
    protected int getPartition() {
        ClientEngine clientEngine = this.getClientEngine();
        Data key = this.serializationService.toData(this.name);
        return clientEngine.getPartitionService().getPartitionId(key);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:atomicLongService";
    }

    @Override
    public int getFactoryId() {
        return AtomicLongPortableHook.F_ID;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("d", this.delta);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.delta = reader.readLong("d");
    }

    @Override
    public Permission getRequiredPermission() {
        return new AtomicLongPermission(this.name, "modify");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.delta};
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

