/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.utils.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.Executor;

public class EchoServer
implements Closeable {
    private final Loggerf log = Loggerf.getLogger(EchoServer.class);
    private final ServerSocket server;
    private final Executor executor;
    private final PrintStream out;

    public EchoServer(ServerSocket socket, Executor executor) {
        this(socket, executor, System.out);
    }

    public EchoServer(ServerSocket socket, Executor executor, PrintStream out) {
        this.server = socket;
        this.executor = executor;
        this.out = out;
    }

    public void start() {
        this.executor.execute(new Runnable(){

            public void run() {
                EchoServer.this.runAcceptLoop();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Socket socket) {
        BufferedReader istream = null;
        try {
            istream = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String string = null;
            while ((string = istream.readLine()) != null) {
                this.log.trace("Echoing: %s", string);
                this.out.println(string);
            }
        }
        catch (Exception e) {
            try {
                this.log.debug("error processing socket", e);
            }
            catch (Throwable throwable) {
                Closer.close(istream);
                throw throwable;
            }
            Closer.close(istream);
        }
        Closer.close(istream);
    }

    public void close() throws IOException {
        if (this.server != null) {
            this.server.close();
        }
    }

    private void runAcceptLoop() {
        try {
            while (true) {
                final Socket socket = this.server.accept();
                this.executor.execute(new Runnable(){

                    public void run() {
                        EchoServer.this.process(socket);
                    }
                });
            }
        }
        catch (Exception e) {
            this.log.debug("", e);
            return;
        }
    }
}

