/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax;

import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.CharDataElement;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.ProcessingInstruction;
import weblogic.xml.babel.baseparser.StartElement;
import weblogic.xml.stax.ConfigurationContextBase;
import weblogic.xml.stax.ReadOnlyNamespaceContext;
import weblogic.xml.stax.util.TypeNames;

public class XMLStreamReaderBase
implements XMLStreamReader,
Location {
    private Element current;
    private BaseParser baseparser;
    protected int eventType;
    private boolean pushBack = false;
    private ArrayList attributes = new ArrayList();
    private ArrayList namespaces = new ArrayList();
    private Object[] outofscope = new Object[0];
    private Map namespacemap;
    private ReadOnlyNamespaceContext nscontext;
    private String textCache;
    private char[] arrayCache;
    private ProcessingInstruction xmldecl;
    private boolean open = true;
    private Attribute tempAttribute = new Attribute();
    private ConfigurationContextBase configContext;

    public XMLStreamReaderBase() {
    }

    private void prime(Reader r) throws XMLStreamException {
        try {
            this.baseparser = new BaseParser(r);
            this.tempAttribute.init();
            this.namespacemap = this.baseparser.getNameSpaceMap();
            this.nscontext = new ReadOnlyNamespaceContext(this.namespacemap);
            this.eventType = 7;
            this.pushBack = true;
            this.current = this.baseparser.parseSome();
            if (this.current.type == 4) {
                ProcessingInstruction pi = (ProcessingInstruction)this.current;
                if (pi.isXMLDecl()) {
                    this.xmldecl = pi;
                    this.pushBack = false;
                } else {
                    this.xmldecl = null;
                }
            }
        }
        catch (Exception e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
    }

    public XMLStreamReaderBase(Reader r) throws XMLStreamException {
        this.prime(r);
    }

    public void setInput(Reader r) throws XMLStreamException {
        this.prime(r);
    }

    public void setConfigurationContext(ConfigurationContextBase base) {
        this.configContext = base;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.configContext.getProperty(name);
    }

    private boolean atStart() {
        return 7 == this.eventType;
    }

    private boolean atEnd() {
        return 8 == this.eventType;
    }

    protected int convert(int type) {
        switch (type) {
            case 0: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                if (this.baseparser.inDocument()) {
                    return 4;
                }
                return 6;
            }
        }
        return -1;
    }

    public int getEventType() {
        return this.eventType;
    }

    protected void setTextCache(String val) {
        this.textCache = val;
    }

    protected void setArrayCache(char[] val) {
        this.arrayCache = val;
    }

    protected String getTextCache() {
        return this.textCache;
    }

    protected char[] getArrayCache() {
        return this.arrayCache;
    }

    protected void setEventType(int type) {
        this.eventType = type;
    }

    protected void advance() throws XMLStreamException {
        try {
            this.textCache = null;
            this.arrayCache = null;
            if (this.pushBack) {
                this.eventType = this.convert(this.current.type);
                this.pushBack = false;
                if (this.isStartElement()) {
                    this.initializeAttributesAndNamespaces();
                }
                if (this.isEndElement()) {
                    this.initializeOutOfScopeNamespaces();
                }
                return;
            }
            if (this.baseparser.hasNext()) {
                this.current = this.baseparser.parseSome();
                this.eventType = this.convert(this.current.type);
                if (this.isStartElement()) {
                    this.initializeAttributesAndNamespaces();
                }
                if (this.isEndElement()) {
                    this.initializeOutOfScopeNamespaces();
                }
                return;
            }
            this.eventType = 8;
        }
        catch (Exception e) {
            throw new XMLStreamException(e.getMessage(), e);
        }
    }

    protected void initializeAttributesAndNamespaces() {
        this.namespaces.clear();
        this.attributes.clear();
        Iterator i = ((StartElement)this.current).getAttributes().iterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            if (a.isNameSpaceDeclaration() || a.declaresDefaultNameSpace()) {
                this.namespaces.add(a);
                continue;
            }
            this.attributes.add(a);
        }
    }

    protected void initializeOutOfScopeNamespaces() {
        this.outofscope = this.baseparser.getOutOfScopeNamespaces();
    }

    public int next() throws XMLStreamException {
        if (!this.open && this.atEnd()) {
            throw new XMLStreamException("next() may not be called when XMLStreamReader is at END_DOCUMENT");
        }
        this.advance();
        if (this.atEnd()) {
            this.open = false;
        }
        return this.eventType;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.open;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type == this.eventType && namespaceURI.equals(this.getNamespaceURI()) && localName.equals(this.getLocalName())) {
            return;
        }
        if (type != this.eventType) {
            throw new XMLStreamException("Event types did not match");
        }
        if (!namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("The supplied namespace URI " + namespaceURI + " did not " + "match the current namespace URI  " + this.getNamespaceURI());
        }
        throw new XMLStreamException("The supplied local name " + localName + " did not match the current local name " + this.getLocalName());
    }

    public int nextTag() throws XMLStreamException {
        do {
            if (this.next() == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (!this.isCharacters() || this.isWhiteSpace()) continue;
            throw new XMLStreamException("Unexpected text");
        } while (!this.isStartElement() && !this.isEndElement());
        return this.getEventType();
    }

    public String getElementText() throws XMLStreamException {
        StringBuffer buf = new StringBuffer();
        if (this.getEventType() != 1) {
            throw new XMLStreamException("Precondition for readText is getEventType() == START_ELEMENT");
        }
        do {
            if (this.next() == 8) {
                throw new XMLStreamException("Unexpected end of Document");
            }
            if (this.isStartElement()) {
                throw new XMLStreamException("Unexpected Element start");
            }
            if (!this.isCharacters()) continue;
            buf.append(this.getText());
        } while (!this.isEndElement());
        return buf.toString();
    }

    public void close() throws XMLStreamException {
    }

    protected boolean checkStartOrEnd() {
        if (this.isStartElement() || this.isEndElement()) {
            return true;
        }
        throw new IllegalStateException("Attempted operation is valid only on a START_ELEMENT or END_ELEMENT");
    }

    protected boolean checkStartElement() {
        if (!this.isStartElement()) {
            throw new IllegalStateException("Attempted operation is only valid on an START_ELEMENT");
        }
        return true;
    }

    protected boolean checkEndElement() {
        if (!this.isEndElement()) {
            throw new IllegalStateException("Attempted operation is only valid on an END_ELEMENT");
        }
        return true;
    }

    public QName getAttributeName(int index) {
        return new QName(this.getAttributeNamespace(index), this.getAttributeLocalName(index), this.getAttributePrefix(index));
    }

    public int getAttributeCount() {
        if (this.isStartElement()) {
            return this.attributes.size();
        }
        throw new IllegalStateException("Unable to access attributes on a non START_ELEMENT");
    }

    public String getAttributeValue(String namespaceUri, String localName) {
        int i = 0;
        while (i < this.getAttributeCount()) {
            Attribute a = this.getAttributeInternal(i);
            if (localName.equals(a.getLocalName())) {
                if (namespaceUri == null) {
                    return a.getValue();
                }
                if (namespaceUri.equals(a.getURI())) {
                    return a.getValue();
                }
            }
            ++i;
        }
        return null;
    }

    private Attribute getAttributeInternal(int index) {
        return (Attribute)this.attributes.get(index);
    }

    private Attribute getNamespaceInternal(int index) {
        if (this.isStartElement()) {
            return (Attribute)this.namespaces.get(index);
        }
        PrefixMapping m = (PrefixMapping)this.outofscope[index];
        this.tempAttribute.setLocalName(m.getPrefix());
        this.tempAttribute.setValue(m.getOldUri());
        return this.tempAttribute;
    }

    public String getAttributeNamespace(int index) {
        this.checkStartElement();
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getURI();
    }

    public String getAttributeLocalName(int index) {
        this.checkStartElement();
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getLocalName();
    }

    public String getAttributePrefix(int index) {
        this.checkStartElement();
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getPrefix();
    }

    public String getAttributeType(int index) {
        this.checkStartElement();
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        this.checkStartElement();
        Attribute a = this.getAttributeInternal(index);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public boolean isAttributeSpecified(int index) {
        this.checkStartElement();
        return false;
    }

    public String getNamespaceURI(String prefix) {
        this.checkStartOrEnd();
        if (this.namespacemap == null) {
            return null;
        }
        return (String)this.namespacemap.get(prefix);
    }

    public int getNamespaceCount() {
        this.checkStartOrEnd();
        if (this.isStartElement()) {
            return this.namespaces.size();
        }
        return this.outofscope.length;
    }

    public String getNamespacePrefix(int index) {
        this.checkStartOrEnd();
        Attribute a = this.getNamespaceInternal(index);
        if (a == null) {
            return null;
        }
        if (a.declaresDefaultNameSpace()) {
            return null;
        }
        return a.getLocalName();
    }

    protected static String checkNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String getNamespaceURI(int index) {
        this.checkStartOrEnd();
        Attribute a = this.getNamespaceInternal(index);
        if (a == null) {
            return null;
        }
        return XMLStreamReaderBase.checkNull(a.getValue());
    }

    public NamespaceContext getNamespaceContext() {
        return this.nscontext;
    }

    public XMLStreamReader subReader() throws XMLStreamException {
        return null;
    }

    public String getText() {
        if (this.textCache == null) {
            if (this.current.type != 5 && this.current.type != 6 && this.current.type != 7) {
                throw new IllegalStateException("Attempt to access text from an illegal state");
            }
            CharDataElement cde = (CharDataElement)this.current;
            this.textCache = cde.getContent();
        }
        return this.textCache;
    }

    public int getTextCharacters(int src, char[] target, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public char[] getTextCharacters() {
        if (this.arrayCache == null) {
            if (this.current.type != 5 && this.current.type != 6 && this.current.type != 7) {
                throw new IllegalStateException("Attempt to access text from an illegal state");
            }
            CharDataElement cde = (CharDataElement)this.current;
            this.arrayCache = cde.getArray();
        }
        return this.arrayCache;
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        return this.getTextCharacters().length;
    }

    public boolean hasText() {
        return this.eventType == 4 | this.eventType == 11 | this.eventType == 5 | this.eventType == 9;
    }

    public String getLocalName() {
        return this.current.getLocalName();
    }

    public boolean hasName() {
        return this.eventType == 1 | this.eventType == 2 | this.eventType == 9;
    }

    public QName getName() {
        return new QName(this.getNamespaceURI(), this.getLocalName(), this.getPrefix());
    }

    public String getNamespaceURI() {
        return XMLStreamReaderBase.checkNull(this.current.getURI());
    }

    public String getPrefix() {
        return this.current.getPrefix();
    }

    public String getVersion() {
        if (this.xmldecl == null) {
            return "1.0";
        }
        return this.xmldecl.getVersion();
    }

    public boolean isStandalone() {
        if (this.xmldecl == null) {
            return false;
        }
        return "yes".equals(this.xmldecl.getStandalone());
    }

    public boolean standaloneSet() {
        return this.xmldecl != null;
    }

    public String getCharacterEncodingScheme() {
        if (this.xmldecl == null) {
            return "utf-8";
        }
        return this.xmldecl.getEncoding();
    }

    public String getPITarget() {
        ProcessingInstruction pi = (ProcessingInstruction)this.current;
        return pi.getTarget();
    }

    public String getPIData() {
        ProcessingInstruction pi = (ProcessingInstruction)this.current;
        return pi.getData();
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return this;
    }

    public int getLineNumber() {
        return this.current.getLine();
    }

    public int getColumnNumber() {
        return this.current.getColumn();
    }

    public int getCharacterOffset() {
        return -1;
    }

    public String getLocationURI() {
        return null;
    }

    public boolean isStartElement() {
        return this.eventType == 1;
    }

    public boolean isEndElement() {
        return this.eventType == 2;
    }

    public boolean isCharacters() {
        return this.eventType == 4;
    }

    public boolean isWhiteSpace() {
        return ((CharDataElement)this.current).isSpace();
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    private static void printName(String prefix, String uri, String localName, StringBuffer b) {
        if (uri != null && !"".equals(uri)) {
            b.append("['" + uri + "']:");
        }
        if (prefix != null) {
            b.append(prefix + ":");
        }
        if (localName != null) {
            b.append(localName);
        }
    }

    private static void printName(XMLStreamReader xmlr, StringBuffer b) {
        if (xmlr.hasName()) {
            String prefix = xmlr.getPrefix();
            String uri = xmlr.getNamespaceURI();
            String localName = xmlr.getLocalName();
            XMLStreamReaderBase.printName(prefix, uri, localName, b);
        }
    }

    public static String printEvent(XMLStreamReader xmlr) {
        StringBuffer b = new StringBuffer();
        b.append("EVENT:[" + xmlr.getLocation().getLineNumber() + "][" + xmlr.getLocation().getColumnNumber() + "] ");
        b.append(TypeNames.getName(xmlr.getEventType()));
        b.append(" [");
        switch (xmlr.getEventType()) {
            case 1: {
                b.append("<");
                XMLStreamReaderBase.printName(xmlr, b);
                int i = 0;
                while (i < xmlr.getNamespaceCount()) {
                    b.append(" ");
                    String n = xmlr.getNamespacePrefix(i);
                    if ("xmlns".equals(n)) {
                        b.append("xmlns=\"" + xmlr.getNamespaceURI(i) + "\"");
                    } else {
                        b.append("xmlns:" + n);
                        b.append("=\"");
                        b.append(xmlr.getNamespaceURI(i));
                        b.append("\"");
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < xmlr.getAttributeCount()) {
                    b.append(" ");
                    XMLStreamReaderBase.printName(xmlr.getAttributePrefix(i2), xmlr.getAttributeNamespace(i2), xmlr.getAttributeLocalName(i2), b);
                    b.append("=\"");
                    b.append(xmlr.getAttributeValue(i2));
                    b.append("\"");
                    ++i2;
                }
                b.append(">");
                break;
            }
            case 2: {
                b.append("</");
                XMLStreamReaderBase.printName(xmlr, b);
                int i = 0;
                while (i < xmlr.getNamespaceCount()) {
                    b.append(" ");
                    String n = xmlr.getNamespacePrefix(i);
                    if ("xmlns".equals(n)) {
                        b.append("xmlns=\"" + xmlr.getNamespaceURI(i) + "\"");
                    } else {
                        b.append("xmlns:" + n);
                        b.append("=\"");
                        b.append(xmlr.getNamespaceURI(i));
                        b.append("\"");
                    }
                    ++i;
                }
                b.append(">");
                break;
            }
            case 4: 
            case 6: {
                int start = xmlr.getTextStart();
                int length = xmlr.getTextLength();
                b.append(new String(xmlr.getTextCharacters(), start, length));
                break;
            }
            case 3: {
                String data;
                String target = xmlr.getPITarget();
                if (target == null) {
                    target = "";
                }
                if ((data = xmlr.getPIData()) == null) {
                    data = "";
                }
                b.append("<?");
                b.append(target + " " + data);
                b.append("?>");
                break;
            }
            case 12: {
                b.append("<![CDATA[");
                if (xmlr.hasText()) {
                    b.append(xmlr.getText());
                }
                b.append("]]>");
                break;
            }
            case 5: {
                b.append("<!--");
                if (xmlr.hasText()) {
                    b.append(xmlr.getText());
                }
                b.append("-->");
                break;
            }
            case 9: {
                b.append(xmlr.getLocalName() + "=");
                if (!xmlr.hasText()) break;
                b.append("[" + xmlr.getText() + "]");
                break;
            }
            case 7: {
                b.append("<?xml");
                b.append(" version='" + xmlr.getVersion() + "'");
                b.append(" encoding='" + xmlr.getCharacterEncodingScheme() + "'");
                if (xmlr.isStandalone()) {
                    b.append(" standalone='yes'");
                } else {
                    b.append(" standalone='no'");
                }
                b.append("?>");
            }
        }
        b.append("]");
        return b.toString();
    }

    public String toString() {
        return XMLStreamReaderBase.printEvent(this);
    }

    public static void main(String[] args) throws Exception {
        FileReader in = new FileReader(args[0]);
        XMLStreamReaderBase r = new XMLStreamReaderBase(in);
        while (r.hasNext()) {
            System.out.println(((Object)r).toString());
            r.next();
        }
    }
}

