/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.CharsetMapping;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class SingleByteCharsetConverter {
    private static byte[] unknownCharsMap;
    private static final int BYTE_RANGE = 256;
    private static final Map CONVERTER_MAP;
    private static byte[] allBytes;
    private char[] byteToChars = new char[256];
    private byte[] charToByteMap = new byte[65536];
    private static final byte[] EMPTY_BYTE_ARRAY;

    private SingleByteCharsetConverter(String encodingName) throws UnsupportedEncodingException {
        String allBytesString = new String(allBytes, 0, 256, encodingName);
        int allBytesLen = allBytesString.length();
        System.arraycopy(unknownCharsMap, 0, this.charToByteMap, 0, this.charToByteMap.length);
        for (int i = 0; i < 256 && i < allBytesLen; ++i) {
            char c;
            this.byteToChars[i] = c = allBytesString.charAt(i);
            this.charToByteMap[c] = allBytes[i];
        }
    }

    public static synchronized SingleByteCharsetConverter getInstance(String encodingName) throws UnsupportedEncodingException {
        SingleByteCharsetConverter instance = (SingleByteCharsetConverter)CONVERTER_MAP.get(encodingName);
        if (instance == null) {
            instance = SingleByteCharsetConverter.initCharset(encodingName);
        }
        return instance;
    }

    public static SingleByteCharsetConverter initCharset(String javaEncodingName) throws UnsupportedEncodingException {
        String mysqlEncodingName = (String)CharsetMapping.JAVA_TO_MYSQL_CHARSET_MAP.get(javaEncodingName);
        if (mysqlEncodingName == null) {
            return null;
        }
        if (CharsetMapping.MULTIBYTE_CHARSETS.containsKey(mysqlEncodingName)) {
            return null;
        }
        SingleByteCharsetConverter converter = new SingleByteCharsetConverter(javaEncodingName);
        CONVERTER_MAP.put(javaEncodingName, converter);
        return converter;
    }

    public static String toStringDefaultEncoding(byte[] buffer, int startPos, int length) {
        return new String(buffer, startPos, length);
    }

    public final byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            bytes[i] = this.charToByteMap[c];
        }
        return bytes;
    }

    public final byte[] toBytes(String s, int offset, int length) {
        if (s == null) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        int stringLength = s.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i + offset);
            bytes[i] = this.charToByteMap[c];
        }
        return bytes;
    }

    public final String toString(byte[] buffer) {
        return this.toString(buffer, 0, buffer.length);
    }

    public final String toString(byte[] buffer, int startPos, int length) {
        char[] charArray = new char[length];
        int readpoint = startPos;
        for (int i = 0; i < length; ++i) {
            charArray[i] = this.byteToChars[buffer[readpoint] - -128];
            ++readpoint;
        }
        return new String(charArray);
    }

    static {
        int i;
        unknownCharsMap = new byte[65536];
        CONVERTER_MAP = new HashMap();
        allBytes = new byte[256];
        for (i = -128; i <= 127; ++i) {
            SingleByteCharsetConverter.allBytes[i - -128] = (byte)i;
        }
        for (i = 0; i < unknownCharsMap.length; ++i) {
            SingleByteCharsetConverter.unknownCharsMap[i] = 63;
        }
        EMPTY_BYTE_ARRAY = new byte[0];
    }
}

