/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable {
    private String elementTag = null;
    private Vector children = new Vector();
    private Object wrappedObject = null;
    private AttributeList attributes;
    private StringBuffer characters = new StringBuffer();
    private boolean proxyConfigured = false;

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.wrappedObject = proxy;
        this.elementTag = elementTag;
        this.proxyConfigured = false;
    }

    void setProxy(Object proxy) {
        this.wrappedObject = proxy;
        this.proxyConfigured = false;
    }

    public void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void addChild(RuntimeConfigurable child) {
        this.children.addElement(child);
    }

    RuntimeConfigurable getChild(int index) {
        return (RuntimeConfigurable)this.children.elementAt(index);
    }

    public void addText(String data) {
        this.characters.append(data);
    }

    public void addText(char[] buf, int start, int count) {
        this.addText(new String(buf, start, count));
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p) throws BuildException {
        this.maybeConfigure(p, true);
    }

    public void maybeConfigure(Project p, boolean configureChildren) throws BuildException {
        String id = null;
        if (this.proxyConfigured) {
            return;
        }
        if (this.attributes != null) {
            ProjectHelper.configure(this.wrappedObject, this.attributes, p);
            id = this.attributes.getValue("id");
        }
        if (this.characters.length() != 0) {
            ProjectHelper.addText(p, this.wrappedObject, this.characters.toString());
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Task childTask;
            RuntimeConfigurable child = (RuntimeConfigurable)enumeration.nextElement();
            if (child.wrappedObject instanceof Task) {
                childTask = (Task)child.wrappedObject;
                childTask.setRuntimeConfigurableWrapper(child);
            }
            if (!configureChildren) continue;
            if (child.wrappedObject instanceof Task) {
                childTask = (Task)child.wrappedObject;
                childTask.maybeConfigure();
            } else {
                child.maybeConfigure(p);
            }
            ProjectHelper.storeChild(p, this.wrappedObject, child.wrappedObject, child.getElementTag().toLowerCase(Locale.US));
        }
        if (id != null) {
            p.addReference(id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }
}

