/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.RetryableRequest;
import com.hazelcast.cluster.ClusterService;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitionDataSerializerHook;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.Partitions;
import com.hazelcast.partition.client.PartitionsResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public final class GetPartitionsRequest
extends CallableClientRequest
implements IdentifiedDataSerializable,
RetryableRequest {
    public Object call() throws Exception {
        PartitionServiceImpl service = (PartitionServiceImpl)this.getService();
        service.firstArrangement();
        ClusterService clusterService = this.getClientEngine().getClusterService();
        Collection<MemberImpl> memberList = clusterService.getMemberList();
        Address[] addresses = new Address[memberList.size()];
        HashMap<Address, Integer> addressMap = new HashMap<Address, Integer>(memberList.size());
        int k = 0;
        for (MemberImpl member : memberList) {
            Address address;
            addresses[k] = address = member.getAddress();
            addressMap.put(address, k);
            ++k;
        }
        Partitions partitions = service.getPartitions();
        int[] indexes = new int[partitions.size()];
        for (int i = 0; i < indexes.length; ++i) {
            Integer idx;
            Address owner = partitions.get(i).getOwner();
            int index = -1;
            if (owner != null && (idx = (Integer)addressMap.get(owner)) != null) {
                index = idx;
            }
            indexes[i] = index;
        }
        return new PartitionsResponse(addresses, indexes);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

