/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.operations.client;

import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.multimap.impl.operations.MultiMapOperationFactory;
import com.hazelcast.multimap.impl.operations.MultiMapResponse;
import com.hazelcast.multimap.impl.operations.client.MultiMapAllPartitionRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.OperationFactory;
import com.hazelcast.spi.impl.PortableCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class KeySetRequest
extends MultiMapAllPartitionRequest
implements RetryableRequest {
    public KeySetRequest() {
    }

    public KeySetRequest(String name) {
        super(name);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MultiMapOperationFactory(this.name, MultiMapOperationFactory.OperationFactoryType.KEY_SET);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashSet<Data> keySet = new HashSet<Data>();
        for (Object obj : map.values()) {
            MultiMapResponse response;
            Collection coll;
            if (obj == null || (coll = (response = (MultiMapResponse)obj).getCollection()) == null) continue;
            keySet.addAll(coll);
        }
        return new PortableCollection(keySet);
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public String getMethodName() {
        return "keySet";
    }
}

