/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CacheClearBackupOperation
extends AbstractNamedOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private Set<Data> keys;
    private transient ICacheRecordStore cache;

    public CacheClearBackupOperation() {
    }

    public CacheClearBackupOperation(String name, Set<Data> keys) {
        super(name);
        this.keys = keys;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 12;
    }

    @Override
    public void beforeRun() throws Exception {
        CacheService service = (CacheService)this.getService();
        this.cache = service.getOrCreateCache(this.name, this.getPartitionId());
    }

    @Override
    public void run() throws Exception {
        if (this.keys != null) {
            for (Data key : this.keys) {
                this.cache.removeRecord(key);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.keys != null);
        if (this.keys != null) {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                key.writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean isKeysNotNull = in.readBoolean();
        if (isKeysNotNull) {
            int size = in.readInt();
            this.keys = new HashSet<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data key = new Data();
                key.readData(in);
                this.keys.add(key);
            }
        }
    }
}

