/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.client;

import com.hazelcast.collection.CollectionRemoveOperation;
import com.hazelcast.collection.client.CollectionRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class CollectionRemoveRequest
extends CollectionRequest {
    private Data value;

    public CollectionRemoveRequest() {
    }

    public CollectionRemoveRequest(String name, Data value) {
        super(name);
        this.value = value;
    }

    @Override
    protected Operation prepareOperation() {
        return new CollectionRemoveOperation(this.name, this.value);
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        this.value.writeData(writer.getRawDataOutput());
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.value = new Data();
        this.value.readData(reader.getRawDataInput());
    }

    @Override
    public String getRequiredAction() {
        return "remove";
    }

    @Override
    public String getMethodName() {
        return "remove";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.value};
    }
}

