/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Table;
import org.hsqldb.Trigger;
import org.hsqldb.lib.HsqlDeque;

class TriggerDef
extends Thread {
    static final int NUM_TRIGGER_OPS = 3;
    static final int NUM_TRIGS = 12;
    static final int INSERT_AFTER = 0;
    static final int DELETE_AFTER = 1;
    static final int UPDATE_AFTER = 2;
    static final int INSERT_BEFORE = 3;
    static final int DELETE_BEFORE = 4;
    static final int UPDATE_BEFORE = 5;
    static final int INSERT_AFTER_ROW = 6;
    static final int DELETE_AFTER_ROW = 7;
    static final int UPDATE_AFTER_ROW = 8;
    static final int INSERT_BEFORE_ROW = 9;
    static final int DELETE_BEFORE_ROW = 10;
    static final int UPDATE_BEFORE_ROW = 11;
    String name;
    String when;
    String operation;
    boolean forEachRow;
    boolean nowait;
    int maxRowsQueued;
    protected static int defaultQueueSize = 1024;
    Table table;
    Trigger trig;
    String fire;
    int vectorIndx;
    protected HsqlDeque pendingQueue;
    protected int rowsQueued;
    protected boolean valid;

    public static int getDefaultQueueSize() {
        return defaultQueueSize;
    }

    public TriggerDef(String string, String string2, String string3, boolean bl, Table table, Trigger trigger, String string4, boolean bl2, int n) {
        this.name = string.toUpperCase();
        this.when = string2.toUpperCase();
        this.operation = string3.toUpperCase();
        this.forEachRow = bl;
        this.nowait = bl2;
        this.maxRowsQueued = n;
        this.table = table;
        this.trig = trigger;
        this.fire = string4;
        this.vectorIndx = this.SqlToIndex();
        this.rowsQueued = 0;
        this.pendingQueue = new HsqlDeque();
        this.valid = this.vectorIndx >= 0;
    }

    public StringBuffer toBuf() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("CREATE TRIGGER ");
        stringBuffer.append(this.name);
        stringBuffer.append(" ");
        stringBuffer.append(this.when);
        stringBuffer.append(" ");
        stringBuffer.append(this.operation);
        stringBuffer.append(" ON ");
        stringBuffer.append(this.table.getName().statementName);
        if (this.forEachRow) {
            stringBuffer.append(" FOR EACH ROW ");
        }
        if (this.nowait) {
            stringBuffer.append(" NOWAIT ");
        }
        if (this.maxRowsQueued != TriggerDef.getDefaultQueueSize()) {
            stringBuffer.append(" QUEUE ");
            stringBuffer.append(this.maxRowsQueued);
        }
        stringBuffer.append(" CALL ");
        stringBuffer.append(this.fire);
        return stringBuffer;
    }

    public int SqlToIndex() {
        int n = this.operation.equals("INSERT") ? 0 : (this.operation.equals("DELETE") ? 1 : (this.operation.equals("UPDATE") ? 2 : -1));
        if (this.when.equals("BEFORE")) {
            n += 3;
        } else if (!this.when.equals("AFTER")) {
            n = -1;
        }
        if (this.forEachRow) {
            n += 6;
        }
        return n;
    }

    public void run() {
        boolean bl = true;
        while (bl) {
            Object[] objectArray = this.pop();
            this.trig.fire(this.name, this.table.getName().name, objectArray);
        }
    }

    synchronized Object[] pop() {
        if (this.rowsQueued == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        --this.rowsQueued;
        this.notify();
        return (Object[])this.pendingQueue.removeFirst();
    }

    synchronized void push(Object[] objectArray) {
        if (this.rowsQueued >= this.maxRowsQueued) {
            if (this.nowait) {
                this.pendingQueue.removeLast();
            } else {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++this.rowsQueued;
            }
        } else {
            ++this.rowsQueued;
        }
        this.pendingQueue.add(objectArray);
        this.notify();
    }

    public static int numTrigs() {
        return 12;
    }

    public boolean isBusy() {
        return this.rowsQueued != 0;
    }

    public boolean isValid() {
        return this.valid;
    }
}

