/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.Cache;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseFile;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.QuotedTextDatabaseRowInput;
import org.hsqldb.QuotedTextDatabaseRowOutput;
import org.hsqldb.Table;
import org.hsqldb.TextDatabaseRowInput;
import org.hsqldb.TextDatabaseRowOutput;
import org.hsqldb.Trace;

class TextCache
extends Cache {
    public static final String NL = System.getProperty("line.separator");
    private String fs;
    private String vs;
    private String lvs;
    private DatabaseRowOutputInterface out;
    protected boolean readOnly;
    protected TextDatabaseRowInput in;
    protected boolean ignoreFirst;
    protected String ignoredFirst = NL;

    TextCache(String string, String string2, HsqlDatabaseProperties hsqlDatabaseProperties) throws SQLException {
        super("", hsqlDatabaseProperties);
        String string3;
        String string4;
        String string5;
        TextSource textSource = new TextSource(string);
        this.fs = this.translateSep(textSource.getAttr("fs", null));
        this.vs = textSource.getAttr("vs", this.fs);
        if (this.vs != this.fs) {
            this.vs = this.translateSep(this.vs);
        }
        if ((string5 = textSource.getAttr("lvs", this.fs)) != this.fs) {
            string5 = this.translateSep(string5);
        }
        if (this.fs == null) {
            this.fs = this.translateSep(hsqlDatabaseProperties.getProperty(string2 + "fs"), true);
            if (this.fs == null) {
                this.fs = ",";
            }
        }
        if (this.vs == null) {
            this.vs = hsqlDatabaseProperties.getProperty(string2 + "vs", this.fs);
            if (this.vs != this.fs) {
                this.vs = this.translateSep(this.vs, true);
            }
        }
        if (string5 == null && (string5 = hsqlDatabaseProperties.getProperty(string2 + "lvs", this.fs)) != this.fs) {
            string5 = this.translateSep(string5, true);
        }
        if ((string4 = textSource.getAttr("ignore_first", null)) == null) {
            string4 = hsqlDatabaseProperties.getProperty(string2 + "ignore_first", "false");
        }
        this.ignoreFirst = string4.equals("true");
        String string6 = textSource.getAttr("quoted", null);
        if (string6 == null) {
            string6 = hsqlDatabaseProperties.getProperty(string2 + "quoted", "true");
        }
        if ((string3 = textSource.getAttr("empty_is_null", null)) == null) {
            string3 = hsqlDatabaseProperties.getProperty(string2 + "empty_is_null", "true");
        }
        this.sName = textSource.source;
        if (this.sName.endsWith(";")) {
            this.sName = this.sName.substring(0, this.sName.length() - 1);
        }
        try {
            if (string6.equals("true")) {
                this.in = new QuotedTextDatabaseRowInput(this.fs, this.vs, string5, string3.equals("true"));
                this.out = new QuotedTextDatabaseRowOutput(this.fs, this.vs, string5);
            } else {
                this.in = new TextDatabaseRowInput(this.fs, this.vs, string5, string3.equals("true"));
                this.out = new TextDatabaseRowOutput(this.fs, this.vs, string5);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, "invalid separator(s):" + iOException);
        }
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = 0;
        n = string.indexOf(92);
        if (n != -1) {
            int n2 = 0;
            char[] cArray = string.toCharArray();
            int n3 = 0;
            int n4 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n4);
            do {
                stringBuffer.append(cArray, n2, n - n2);
                n2 = ++n;
                if (n >= n4) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl) {
                    n3 = cArray[n];
                }
                if (n3 == 110) {
                    stringBuffer.append('\n');
                    ++n2;
                    continue;
                }
                if (n3 == 114) {
                    stringBuffer.append('\r');
                    ++n2;
                    continue;
                }
                if (n3 == 116) {
                    stringBuffer.append('\t');
                    ++n2;
                    continue;
                }
                if (n3 == 92) {
                    stringBuffer.append('\\');
                    ++n2;
                    continue;
                }
                if (n3 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n2, n2 + 4), 16));
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("semi", n)) {
                    stringBuffer.append(';');
                    n2 += 4;
                    continue;
                }
                if (string.startsWith("space", n)) {
                    stringBuffer.append(' ');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("quote", n)) {
                    stringBuffer.append('\"');
                    n2 += 5;
                    continue;
                }
                if (string.startsWith("apos", n)) {
                    stringBuffer.append('\'');
                    n2 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n]);
                ++n2;
            } while ((n = string.indexOf(92, n2)) != -1);
            stringBuffer.append(cArray, n2, n4 - n2);
            string = stringBuffer.toString();
        }
        return string;
    }

    void open(boolean bl) throws SQLException {
        try {
            this.rFile = new DatabaseFile(this.sName, bl ? "r" : "rw", 4096);
            this.iFreePos = (int)this.rFile.length();
            if (this.iFreePos == 0 && this.ignoreFirst) {
                this.rFile.write(this.ignoredFirst.getBytes());
                this.iFreePos = this.ignoredFirst.length();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " opening " + this.sName);
        }
        this.readOnly = bl;
    }

    void reopen() throws SQLException {
        this.open(this.readOnly);
        this.in.reset();
    }

    void flush() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(0L);
            this.saveAll();
            boolean bl = this.rFile.length() <= (long)NL.length();
            this.rFile.close();
            this.rFile = null;
            if (bl && !this.readOnly) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " closing " + this.sName);
        }
    }

    void purge() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            if (this.readOnly) {
                this.flush();
            } else {
                this.rFile.close();
                this.rFile = null;
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " purging " + this.sName);
        }
    }

    void free(CachedRow cachedRow) throws SQLException {
        int n = cachedRow.iPos;
        int n2 = cachedRow.storageSize;
        StringBuffer stringBuffer = new StringBuffer(n2);
        n2 -= NL.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(' ');
            ++n3;
        }
        stringBuffer.append(NL);
        try {
            this.rFile.seek(n);
            this.rFile.writeBytes(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException + "");
        }
        this.remove(cachedRow);
    }

    protected void setStorageSize(CachedRow cachedRow) throws SQLException {
        int n;
        try {
            this.out.writeData(cachedRow.getData(), cachedRow.getTable());
            n = this.out.toByteArray().length;
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException + "");
        }
        cachedRow.storageSize = n;
    }

    protected CachedRow makeRow(int n, Table table) throws SQLException {
        CachedRow cachedRow = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(80);
            boolean bl = true;
            boolean bl2 = false;
            try {
                int n2;
                this.rFile.readSeek(n);
                while ((n2 = this.rFile.read()) != -1) {
                    char c = (char)(n2 & 0xFF);
                    if (c == '\n') {
                        stringBuffer.append('\n');
                        if (this.ignoreFirst && n == 0) {
                            this.ignoredFirst = stringBuffer.toString();
                            bl = true;
                        }
                        if (!bl) {
                            bl2 = true;
                            break;
                        }
                        n += stringBuffer.length();
                        stringBuffer.setLength(0);
                        bl = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c == '\r') {
                        try {
                            n2 = this.rFile.read();
                            if (n2 == -1) break;
                            c = (char)(n2 & 0xFF);
                            if (c == '\n') {
                                stringBuffer.append('\n');
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        stringBuffer.append('\n');
                        if (this.ignoreFirst && n == 0) {
                            this.ignoredFirst = stringBuffer.toString();
                            bl = true;
                        }
                        if (!bl) {
                            bl2 = true;
                            break;
                        }
                        n += stringBuffer.length();
                        stringBuffer.setLength(0);
                        bl = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c != ' ') {
                        bl = false;
                    }
                    stringBuffer.append(c);
                }
            }
            catch (Exception exception) {
                bl2 = false;
            }
            if (bl2) {
                this.in.setSource(stringBuffer.toString(), n);
                cachedRow = new CachedRow(table, this.in);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Trace.error(29, "reading: " + exception);
        }
        return cachedRow;
    }

    protected void saveRow(CachedRow cachedRow) throws IOException, SQLException {
        this.rFile.seek(cachedRow.iPos);
        cachedRow.write(this.out);
        this.rFile.write(this.out.toByteArray());
    }

    private class TextSource {
        private String source;

        TextSource(String string) {
            this.source = string;
        }

        String getAttr(String string, String string2) {
            string = ";" + string + "=";
            int n = string.length();
            int n2 = this.source.indexOf(string);
            if (n2 != -1) {
                int n3 = this.source.indexOf(";", n2 += n);
                if (n3 == -1) {
                    n3 = this.source.length();
                }
                string2 = this.source.substring(n2, n3);
                this.source = this.source.substring(0, n2 - n) + this.source.substring(n3);
            }
            return string2;
        }
    }
}

