/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc2.optional;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.postgresql.Driver;
import org.postgresql.jdbc2.optional.BaseDataSource;
import org.postgresql.jdbc2.optional.PooledConnectionImpl;

public class ConnectionPool
extends BaseDataSource
implements Serializable,
ConnectionPoolDataSource {
    private boolean defaultAutoCommit = false;

    public String getDescription() {
        return "ConnectionPoolDataSource from " + Driver.getVersion();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return new PooledConnectionImpl(this.getConnection(), this.defaultAutoCommit);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledConnectionImpl(this.getConnection(user, password), this.defaultAutoCommit);
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeBaseObject(out);
        out.writeBoolean(this.defaultAutoCommit);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readBaseObject(in);
        this.defaultAutoCommit = in.readBoolean();
    }
}

