/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.email;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Message;

abstract class Mailer {
    protected String host = null;
    protected int port = -1;
    protected Message message;
    protected EmailAddress from;
    protected Vector toList = null;
    protected Vector ccList = null;
    protected Vector bccList = null;
    protected Vector files = null;
    protected String subject = null;
    protected Task task;
    protected boolean includeFileNames = false;
    private static DateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);

    Mailer() {
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMessage(Message m) {
        this.message = m;
    }

    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public void setToList(Vector list) {
        this.toList = list;
    }

    public void setCcList(Vector list) {
        this.ccList = list;
    }

    public void setBccList(Vector list) {
        this.bccList = list;
    }

    public void setFiles(Vector files) {
        this.files = files;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public void setIncludeFileNames(boolean b) {
        this.includeFileNames = b;
    }

    public abstract void send() throws BuildException;

    protected final String getDate() {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        int offset = tz.getOffset(cal.get(0), cal.get(1), cal.get(2), cal.get(5), cal.get(7), cal.get(14));
        StringBuffer tzMarker = new StringBuffer(offset < 0 ? "-" : "+");
        offset = Math.abs(offset);
        int hours = offset / 3600000;
        int minutes = offset / 60000 - 60 * hours;
        if (hours < 10) {
            tzMarker.append("0");
        }
        tzMarker.append(hours);
        if (minutes < 10) {
            tzMarker.append("0");
        }
        tzMarker.append(minutes);
        return df.format(cal.getTime()) + tzMarker.toString();
    }
}

