/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax.events;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import weblogic.utils.collections.Iterators;
import weblogic.xml.stax.events.NamedEvent;

public class StartElementEvent
extends NamedEvent
implements StartElement {
    private List attributes;
    private List namespaces;
    private NamespaceContext context;

    public StartElementEvent() {
        this.init();
    }

    public StartElementEvent(QName name) {
        super(name);
        this.init();
    }

    public void reset() {
        if (this.attributes != null) {
            this.attributes.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (this.context != null) {
            this.context = null;
        }
    }

    public StartElementEvent(StartElement element) {
        super(element.getName());
        this.init();
        this.setName(element.getName());
        Iterator ai = element.getAttributes();
        while (ai.hasNext()) {
            this.addAttribute((Attribute)ai.next());
        }
        Iterator ni = element.getNamespaces();
        ni = element.getNamespaces();
        while (ni.hasNext()) {
            this.addNamespace((Namespace)ni.next());
        }
    }

    protected void init() {
        this.setEventType(1);
    }

    public Iterator getAttributes() {
        if (this.attributes == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return this.attributes.iterator();
    }

    public Iterator getNamespaces() {
        if (this.namespaces == null) {
            return Iterators.EMPTY_ITERATOR;
        }
        return this.namespaces.iterator();
    }

    public Attribute getAttributeByName(QName name) {
        if (name == null) {
            return null;
        }
        Iterator i = this.getAttributes();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attribute);
    }

    public void addNamespace(Namespace attribute) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        this.namespaces.add(attribute);
    }

    public String getNamespaceURI(String prefix) {
        if (this.context == null) {
            return null;
        }
        return this.context.getNamespaceURI(prefix);
    }

    public void setNamespaceContext(NamespaceContext c) {
        this.context = c;
    }

    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    public String toString() {
        String value = "<" + this.nameAsString();
        Iterator ai = this.getAttributes();
        while (ai.hasNext()) {
            value = value + " " + ai.next().toString();
        }
        Iterator ni = this.getNamespaces();
        while (ni.hasNext()) {
            value = value + " " + ni.next().toString();
        }
        value = value + ">";
        return value;
    }
}

